/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.spring.boot.mt.config;

import liquibase.integration.spring.SpringResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

public class LiquibaseLifecycleManagementCondition extends AllNestedConditions {
    public LiquibaseLifecycleManagementCondition() {
        super(ConfigurationPhase.PARSE_CONFIGURATION);
    }


    @ConditionalOnProperty(name = "com.sap.mt.liquibase-lifecycle-management", havingValue = "true")
    static class OnLiquibaseLifecycleManagementNotSwitchedOff {
    }

    @ConditionalOnClass({ResourceAccessor.class, SpringResourceAccessor.class})
    static class OnLiquibaseClassesAvailable {
    }
}
