/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.security.adapter.spring.SpringSecurityContext;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.spring.boot.mt.lib.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.function.Supplier;

@Configuration("comSapMtTokenForJavaSecurityConfig")
@ConditionalOnClass(SpringSecurityContext.class)
@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
public class TokenForJavaSecurityConfig {
    public static final Logger logger = LoggerFactory.getLogger(TokenForJavaSecurityConfig.class);

    @Bean("comSapMtToken")
    public Supplier<Token> token() {
        return () -> {
            Token token = SpringSecurityContext.getToken();
            if (logger.isDebugEnabled()) {
                if (token == null) {
                    logger.debug("Returned token is null");
                } else {
                    logger.debug("Retrieved token has zone id {}", token.getZoneId());
                }
            }
            return token;
        };
    }

    @Bean("comSapMtAccessToken")
    public Supplier<AccessToken> accessToken() {
        return () -> {
            AccessToken accessToken = SpringSecurityContext.getAccessToken();
            if (logger.isDebugEnabled()) {
                if (accessToken == null) {
                    logger.debug("Returned access token is null");
                } else {
                    logger.debug("Retrieved access token has zone id {}", accessToken.getZoneId());
                }
            }
            return accessToken;
        };
    }
}
