/*
 * *************************************************************************
 *  * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *  *************************************************************************
 */

package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.mt.subscription.DynamicHdiDeploymentParameters;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;

@Configuration("ComSapMtDynamicHdiDeploymentParametersConfig")
@ConfigurationProperties("com.sap.mt")
@ConditionalOnProperty(prefix = "com.sap.mt", name = "dynamic-db-deployment-url")
public class DynamicHdiDeploymentParametersConfig {
    private String dynamicDbDeploymentUrl;
    private String dynamicDbDeploymentUser;
    private String dynamicDbDeploymentPassword;
    private long maxAsyncDeployWaitTimeSeconds = 10 * 60L;
    private long asyncDeployPollTimeSeconds = 10;

    @Bean("ComSapMtDynamicHdiDeploymentParameters")
    public DynamicHdiDeploymentParameters dynamicHdiDeploymentParameters(Config config) {
        PollingParameters pollingParameters =
                PollingParameters.Builder.create().interval(Duration.ofSeconds(asyncDeployPollTimeSeconds)).timeout(Duration.ofSeconds(maxAsyncDeployWaitTimeSeconds)).build();
        return new DynamicHdiDeploymentParameters(dynamicDbDeploymentUrl, dynamicDbDeploymentUser, dynamicDbDeploymentPassword,
                pollingParameters,
                ResilienceConfig.builder().numOfRetries(config.getMaxRetries()).retryInterval(config.getRetryWaitTime()).build());
    }

    public void setDynamicDbDeploymentUrl(String dynamicDbDeploymentUrl) {
        this.dynamicDbDeploymentUrl = dynamicDbDeploymentUrl;
    }

    public void setDynamicDbDeploymentUser(String dynamicDbDeploymentUser) {
        this.dynamicDbDeploymentUser = dynamicDbDeploymentUser;
    }

    public void setDynamicDbDeploymentPassword(String dynamicDbDeploymentPassword) {
        this.dynamicDbDeploymentPassword = dynamicDbDeploymentPassword;
    }

    public void setMaxAsyncDeployWaitTimeSeconds(long maxAsyncDeployWaitTimeSeconds) {
        this.maxAsyncDeployWaitTimeSeconds = maxAsyncDeployWaitTimeSeconds;
    }

    public void setAsyncDeployPollTimeSeconds(long asyncDeployPollTimeSeconds) {
        this.asyncDeployPollTimeSeconds = asyncDeployPollTimeSeconds;
    }
}
