/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.spring.boot.mt.config;

import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerBuilder;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.spring.boot.mt.lib.Const;
import com.sap.xsa.core.instancemanager.client.ServiceManagerClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Configuration bean that setups an instance lifecycle manager bean. Users can define their own bean
 * to realize multi tenancy without SAP's instance manager service or service manager
 */
@Configuration("ComSapMtInstanceLifecycleManagerConfig")
@ConditionalOnProperty(name = Const.COM_SAP_MT_ENABLED, matchIfMissing = true)
@ConditionalOnMissingBean(InstanceLifecycleManager.class)
public class InstanceLifecycleManagerConfig {
    @Bean("comSapMtInstanceLifecycleManager")
    public InstanceLifecycleManager instanceLifecycleManagerForManagedHana(
            @Autowired(required = false) ServiceManagerClient serviceManagerClient,
            DbIdentifiers dbIdentifiers,
            Config config) throws InternalError {
        return InstanceLifecycleManagerBuilder.create()
                .serviceManagerClient(serviceManagerClient)
                .dbIdentifiers(dbIdentifiers)
                .smCacheRefreshInterval(config.getServiceManagerCacheRefreshInterval())
                .serviceManagerResilienceConfig(config.getServiceManagerResilience())
                .build();
    }
}
