/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.spring.boot.mt.config;

import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

public class NoLiquibaseLifecycleManagementCondition extends AnyNestedCondition {
    public NoLiquibaseLifecycleManagementCondition() {
        super(ConfigurationPhase.PARSE_CONFIGURATION);
    }


    @ConditionalOnProperty(name = "com.sap.mt.liquibase-lifecycle-management", havingValue = "false", matchIfMissing = true)
    static class OnLiquibaseSwitchedOff {
    }

    @ConditionalOnMissingClass({"liquibase.resource.ResourceAccessor", "liquibase.integration.spring.SpringResourceAccessor"})
    static class OnMissingLiquibaseClass {
    }

}
