/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.spring.boot.mt.lib;

import com.sap.cloud.mt.runtime.TenantOverwrite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * A generic invocation handler that uses a tenant overwrite before invoking the
 * inner invocation handler
 */
public class InvocationHandlerForTenant implements InvocationHandler {
    private final String tenantId;
    private final InvocationHandler invocationHandler;

    public InvocationHandlerForTenant(String tenantId, InvocationHandler invocationHandler) {
        this.tenantId = tenantId;
        this.invocationHandler = invocationHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try (TenantOverwrite overwrite = new TenantOverwrite(tenantId)) {
            return invocationHandler.invoke(proxy, method, args);
        }
    }
}
