/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.spring.boot.mt.lib;

import com.sap.cloud.mt.runtime.EnvironmentAccess;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

import java.util.HashMap;
import java.util.Map;

public class SpringEnvironmentAccess implements EnvironmentAccess {
    private Environment environment;

    public SpringEnvironmentAccess(Environment environment) {
        this.environment = environment;
    }

    @Override
    public <T> T getProperty(String key, Class<T> clazz) {
        return environment.getProperty(key, clazz);
    }

    @Override
    public Map<Object, Object> getPropertiesForPrefix(String prefix) {
        Binder binder = Binder.get(environment);
        Bindable<Map<Object, Object>> propertiesContainer = Bindable.ofInstance(new HashMap<>());
        try {
            binder.bind(prefix, propertiesContainer);
            return propertiesContainer.getValue().get();
        } catch (BindException e) {
            return null;
        }
    }
}
