/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;

import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.util.DynamicClassLoadingException;

import org.fusesource.jansi.WindowsAnsiOutputStream;


/**
 * A {@link ConsoleAppender} which accepts that JANSI mode is requested but not available. Instead of printing the whole
 * stacktrace it just prints a warning.
 */
public class JansiAwareConsoleAppender<E> extends ConsoleAppender<E>
{
	/**
	 * If the throwable attached to the warning is the class loading exception related to jansi loading problems and the
	 * message contains the windows ansi class, it will just drop the throwable. Otherwise nothing changes.
	 */
	@Override
	public void addWarn(final String msg, final Throwable ex)
	{
		if (isJansiThrowable(ex))
		{
			super.addWarn(msg, null);
		}
		else
		{
			super.addWarn(msg, ex);
		}
	}

	private boolean isJansiThrowable(final Throwable ex)
	{
		return ex != null
				&& ex.getClass().equals(DynamicClassLoadingException.class)
				&& ex.getMessage() != null
				&& ex.getMessage().contains(WindowsAnsiOutputStream.class.getName());
	}
}
