/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;


/**
 * Lists constants for access of dynamic log fields managed via {@link org.slf4j.MDC}. The log pattern defined in
 * the logback.xml defines some fields filled on a per request base via the MDC. To get this fields filled for a log
 * message they need to be provided via the {@link org.slf4j.MDC} using the constant field name. The field name
 * constants are listed here. Sample usage:
 *
 * <pre>
 * MDC.set(MDCFields.TENANT, &quot;myTenant&quot;);
 * </pre>
 */
public final class MDCFields
{
	/**
	 * Field constant for value containing the calling client identifier.
	 */
	public static final String CLIENT = "client";

	/**
	 * Field constant for value containing the calling client's owner identifier.
	 */
	public static final String CLIENT_OWNER = "client-owner";

	/**
	 * Field constant for value containing the calling service's owner identifier.
	 */
	public static final String SERVICE_OWNER = "service-owner";

	/**
	 * Field constant for value containing the calling tenant. Should not be empty if log is triggered by an incoming
	 * request.
	 */
	public static final String TENANT = "tenant";

	/**
	 * Field constant for value containing the request ID where the incoming request is related to.
	 */
	public static final String REQUEST_ID = "requestId";

	/**
	 * Field constant for value containing the cloud foundry specific request ID where the incoming request is related
	 * to.
	 */
	public static final String VCAP_REQUEST_ID = "vcapRequestId";

	/**
	 * Field constant for value identifying the number of applications the request passed already before it reached
	 * current application.
	 */
	public static final String HOP = "hop";

	/**
	 * Field constant for value identifying the type of a metric in case the log contains a metric value.
	 */
	public static final String METRIC_TYPE = "type";

	/**
	 * Field constant for value identifying the name of a metric in case the log contains a metric value.
	 */
	public static final String METRIC_NAME = "metric";

	private MDCFields()
	{
		// To avoid instantiation
	}
}
