/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.logstash.logback.composite.AbstractFieldJsonProvider;

import org.slf4j.Marker;

import com.fasterxml.jackson.core.JsonGenerator;


/**
 * {@link net.logstash.logback.composite.JsonProvider} writing the {@link Marker}' attached to a log event as array to
 * the JSON document.
 */
public class MarkersJsonProvider extends AbstractFieldJsonProvider<ILoggingEvent>
{
	private static final String FIELD_NAME = "tags";

	/**
	 * Creates a new instance assigning a default field name.
	 */
	public MarkersJsonProvider()
	{
		setFieldName(FIELD_NAME);
	}

	@Override
	public void writeTo(final JsonGenerator generator, final ILoggingEvent event) throws IOException
	{
		final Marker marker = event.getMarker();
		if (event.getMarker() != null)
		{
			generator.writeArrayFieldStart(getFieldName());
			for (final String field : resolveMarkerNames(marker))
			{
				generator.writeString(field);
			}
			generator.writeEndArray();
		}
	}

	private List<String> resolveMarkerNames(final Marker marker)
	{
		if (marker != null)
		{
			final List<String> result = new ArrayList<String>();
			result.add(marker.getName());
			if (marker.hasReferences())
			{
				for (final Iterator<Marker> iter = marker.iterator(); iter.hasNext();)
				{
					final Marker next = iter.next();
					result.addAll(resolveMarkerNames(next));
				}
			}
			return result;
		}
		return Collections.emptyList();
	}
}
