/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Provides utilities for logging metrics.
 * 
 * @deprecated use {@link com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger} instead.
 */
@Deprecated
public final class MetricLogger
{
	/** The name of the marker to mark a log as a metric. **/
	public static final String MARKER_NAME = com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.METRIC_TAG;

	/** The MDC key for setting the metric name. **/
	public static final String MDC_KEY_METRIC = com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.KEY_METRIC;
	/** The MDC key for setting the metric type. **/
	public static final String MDC_KEY_TYPE = com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.KEY_TYPE;

	/** Indicates a numeric metric value. */
	public static final String TYPE_KEY_NUMBER =
			com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.MetricType.NUMBER.toString();
	/** Indicates a textual metric value. */
	public static final String TYPE_KEY_STRING =
			com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.MetricType.STRING.toString();

	private static final Logger LOG = LoggerFactory.getLogger(MetricLogger.class);

	private MetricLogger()
	{
		// avoid instantiation
	}

	/**
	 * Logs a metric in the way that it uses the metric log pattern.
	 * <p>
	 * It will mark the log with a {@link org.slf4j.Marker} of name "METRIC" to activate the log pattern. The metric
	 * value itself will be provided as the log message. All meta data will be provided to the MDC, so the "type" and the
	 * "metric" name.
	 * 
	 * @param numeric is the value a number?
	 * @param value the metric value itself
	 * @param metricName the name of the metric
	 */
	public static void logMetric(final boolean numeric, final Object value, final String metricName)
	{
		com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger
				.newInstance(LOG)
				.type(getMetricType(numeric))
				.metric(metricName)
				.log(value);
	}

	/**
	 * Logs a metric in the way that it uses the metric log pattern.
	 * <p>
	 * It will mark the log with a {@link org.slf4j.Marker} of name "METRIC" to activate the log pattern. The metric
	 * value itself will be provided as the log message. All metadata will be provided to the MDC, so the "type", the
	 * "metric" name, and the "tenant" id.
	 * <p>
	 * If a tenant id is already present in the MDC, it will temporarily be replaced by the given value and then restored
	 * after logging the metric. A warning will also be logged if this temporary replacement in the MDC occurs.
	 * 
	 * @param numeric is the value a number?
	 * @param value the metric value itself
	 * @param metricName the name of the metric
	 * @param tenant the id of the tenant with which the metric is associated
	 */
	public static void logMetric(final boolean numeric, final Object value, final String metricName, final String tenant)
	{
		com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger
				.newInstance(LOG)
				.type(getMetricType(numeric))
				.metric(metricName)
				.tenant(tenant)
				.log(value);
	}

	/**
	 * Logs a metric in the way that it uses the metric log pattern.
	 * <p>
	 * It will mark the log with a {@link org.slf4j.Marker} of name "METRIC" to activate the log pattern. The metric
	 * value itself will be provided as the log message. All metadata will be provided to the MDC, so the "type", the
	 * "metric" name, the "tenant" id, and the "client" identifier.
	 * <p>
	 * If a tenant id is already present in the MDC, it will temporarily be replaced by the given value and then restored
	 * after logging the metric. Likewise, if a client identifier is already present in the MDC, it will temporarily be
	 * replaced by the given value and then restored after logging the metric. A warning will also be logged if this
	 * temporary replacement in the MDC occurs.
	 * 
	 * @param numeric is the value a number?
	 * @param value the metric value itself
	 * @param metricName the name of the metric
	 * @param tenant the id of the tenant with which the metric is associated
	 * @param client the identifier of the caller with which the metric is associated
	 */
	public static void logMetric(
			final boolean numeric, final Object value, final String metricName, final String tenant, final String client)
	{
		com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger
				.newInstance(LOG)
				.type(getMetricType(numeric))
				.metric(metricName)
				.tenant(tenant)
				.client(client)
				.log(value);
	}

	private static com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.MetricType getMetricType(final boolean numeric)
	{
		return numeric
				? com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.MetricType.NUMBER
				: com.sap.cloud.yaas.servicesdk.logging.metric.MetricLogger.MetricType.STRING;
	}

}
