/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;

import net.logstash.logback.decorate.JsonGeneratorDecorator;

import com.fasterxml.jackson.core.JsonGenerator;


/**
 * Decorates a {@link JsonGenerator} to enable pretty printing, so introducing formatting to the JSON output.
 */
public class PrettyPrintingJsonGeneratorDecorator implements JsonGeneratorDecorator
{
	private boolean printPretty;

	@Override
	public JsonGenerator decorate(final JsonGenerator generator)
	{
		if (printPretty)
		{
			return generator.useDefaultPrettyPrinter();
		}
		else
		{
			return generator;
		}
	}

	/**
	 * Whether to enable pretty printing or not.
	 * 
	 * @param printPretty true for enabling pretty printing, false otherwise
	 */
	public void setPrintPretty(final boolean printPretty)
	{
		this.printPretty = printPretty;
	}
}
