/*
 * © 2015 SAP SE or an SAP affiliate company.
 * All rights reserved.
 * Please see http://www.sap.com/corporate-en/legal/copyright/index.epx for additional trademark information and
 * notices.
 */
package com.sap.cloud.yaas.servicesdk.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;

import java.io.IOException;

import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.JsonWritingUtils;

import com.fasterxml.jackson.core.JsonGenerator;


/**
 * {@link net.logstash.logback.composite.JsonProvider} providing the simple class name of the exception assigned to a
 * log event for a JSON document.
 */
public class ThrowableNameJsonProvider extends AbstractFieldJsonProvider<ILoggingEvent>
{
	private static final String FIELD_THROWABLE_NAME = "type";

	/**
	 * Creates a new instance assigning a default field name.
	 */
	public ThrowableNameJsonProvider()
	{
		setFieldName(FIELD_THROWABLE_NAME);
	}

	@Override
	public void writeTo(final JsonGenerator generator, final ILoggingEvent event) throws IOException
	{
		final IThrowableProxy throwableProxy = event.getThrowableProxy();
		if (throwableProxy != null)
		{
			JsonWritingUtils.writeStringField(generator, getFieldName(), event.getThrowableProxy().getClassName());
		}
	}
}
