/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hana.cloud.hcp.cf;

import com.sap.hana.cloud.hcp.service.common.HANAServiceInfo;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.cloud.cloudfoundry.RelationalServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.util.UriInfo;

public class HANAServiceInfoCreator
extends RelationalServiceInfoCreator<HANAServiceInfo> {
    private static final Logger LOG = Logger.getLogger(HANAServiceInfoCreator.class.getName());

    public HANAServiceInfoCreator() {
        super(new Tags(new String[]{"hana"}), new String[]{"sap"});
    }

    public HANAServiceInfo createServiceInfo(String id, String url) {
        return new HANAServiceInfo(id, url);
    }

    public HANAServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        Map credentials = (Map)serviceData.get("credentials");
        String id = (String)serviceData.get("name");
        String host = this.getStringFromCredentials(credentials, new String[]{"hostname", "host"});
        int port = Integer.parseInt(credentials.get("port").toString());
        String username = this.getStringFromCredentials(credentials, new String[]{"user", "username"});
        String password = (String)credentials.get("password");
        String schema = (String)credentials.get("schema");
        String uri = new UriInfo(this.getDefaultUriScheme(), host, port, username, password, null, "currentschema=" + schema).toString();
        return this.createServiceInfo(id, uri);
    }

    protected boolean jdbcUrlMatchesScheme(Map<String, Object> serviceData) {
        String uriScheme = this.getDefaultUriScheme();
        if (uriScheme == null) {
            return false;
        }
        Map credentials = this.getCredentials(serviceData);
        String jdbcUrl = this.getStringFromCredentials(credentials, new String[]{"url"});
        return jdbcUrl != null && jdbcUrl.startsWith("jdbc:" + uriScheme + ":");
    }
}

