/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.cg.ReachabilityAnalyzer;
import com.sap.psr.vulas.goals.AbstractAppGoal;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.java.JarWriter;
import com.sap.psr.vulas.monitor.ClassPoolUpdater;
import com.sap.psr.vulas.shared.enums.GoalClient;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.FileSearch;
import com.sap.psr.vulas.shared.util.StringList;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractReachGoal
extends AbstractAppGoal {
    private static final Log log = LogFactory.getLog(AbstractReachGoal.class);
    private Set<Path> preparedDepClasspath = new HashSet<Path>();
    private Set<Path> preparedAppClasspath = new HashSet<Path>();
    private Set<Path> rewrittenJars = new HashSet<Path>();
    private Set<ConstructId> appConstructs = null;

    protected AbstractReachGoal(GoalType _type) {
        super(_type);
    }

    protected final Set<ConstructId> getAppConstructs() {
        if (this.appConstructs == null) {
            try {
                this.appConstructs = BackendConnector.getInstance().getAppConstructIds(this.getGoalContext(), this.getApplicationContext());
            }
            catch (BackendConnectionException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.appConstructs;
    }

    private final void prepareClasspath() {
        ClassPoolUpdater.getInstance().reset();
        FileSearch jar_search = new FileSearch(JAR_EXT);
        FileSearch class_search = new FileSearch(CLASS_EXT);
        boolean preprocess = this.getConfiguration().getConfiguration().getBoolean("vulas.reach.preprocessDependencies", true);
        StringList exclude_jars = new StringList(this.getConfiguration().getConfiguration().getStringArray("vulas.reach.excludeJars"));
        for (Path p : this.getKnownDependencies().keySet()) {
            Path appended_path = null;
            if (exclude_jars.isEmpty()) {
                appended_path = JarWriter.appendToClasspath(this.preparedDepClasspath, (Path)p, (boolean)preprocess);
            } else if (!exclude_jars.contains(p.getFileName().toString(), StringList.ComparisonMode.PATTERN, StringList.CaseSensitivity.CASE_INSENSITIVE)) {
                appended_path = JarWriter.appendToClasspath(this.preparedDepClasspath, (Path)p, (boolean)preprocess);
            } else {
                log.info((Object)("[" + p + "] excluded from reachability analysis"));
            }
            if (appended_path == null || appended_path.equals(p)) continue;
            this.rewrittenJars.add(appended_path);
        }
        ClassPoolUpdater.getInstance().appendToClasspath(this.preparedDepClasspath);
        for (Path app_dir : this.getAppPaths()) {
            jar_search.clear();
            Set paths = jar_search.search(app_dir);
            for (Path p : paths) {
                Path appended_path = null;
                if (exclude_jars.isEmpty()) {
                    appended_path = JarWriter.appendToClasspath(this.preparedAppClasspath, (Path)p, (boolean)preprocess);
                } else if (!exclude_jars.contains(p.getFileName().toString(), StringList.ComparisonMode.PATTERN, StringList.CaseSensitivity.CASE_INSENSITIVE)) {
                    appended_path = JarWriter.appendToClasspath(this.preparedAppClasspath, (Path)p, (boolean)preprocess);
                } else {
                    log.info((Object)("[" + p + "] excluded from reachability analysis"));
                }
                if (appended_path == null || appended_path.equals(p)) continue;
                this.rewrittenJars.add(appended_path);
            }
            class_search.clear();
            Set classes = class_search.search(app_dir);
            log.info((Object)("Update class path for [" + classes.size() + "] class files"));
            this.preparedAppClasspath.addAll(ClassPoolUpdater.getInstance().getClasspaths(classes));
        }
        ClassPoolUpdater.getInstance().appendToClasspath(this.preparedAppClasspath);
        log.info((Object)("Rewrote [" + this.rewrittenJars.size() + "] dependencies"));
    }

    protected abstract Set<ConstructId> getEntryPoints();

    protected abstract void setEntryPoints(ReachabilityAnalyzer var1);

    protected final void prepareExecution() throws GoalConfigurationException {
        super.prepareExecution();
        this.prepareClasspath();
    }

    protected final void executeTasks() throws Exception {
        ReachabilityAnalyzer ra = new ReachabilityAnalyzer(this.getGoalContext());
        ra.setAppConstructs(this.getAppConstructs());
        ra.setAppClasspaths(this.preparedAppClasspath);
        ra.setDependencyClasspaths(this.preparedDepClasspath);
        if (this.getEntryPoints() == null || this.getEntryPoints().isEmpty()) {
            log.warn((Object)"No entry points, reachability analysis cannot be performed");
            return;
        }
        this.setEntryPoints(ra);
        ra.setCallgraphConstructor(this.getConfiguration().getConfiguration().getString("vulas.reach.fwk", "wala"), this.getGoalClient() == GoalClient.CLI);
        ra.setTargetConstructs(this.getConfiguration().getConfiguration().getString("vulas.reach.bugs", null));
        ra.setExcludePackages(this.getConfiguration().getConfiguration().getString("vulas.reach.excludePackages", null));
        boolean success = ReachabilityAnalyzer.startAnalysis(ra, (long)this.getConfiguration().getConfiguration().getInt("vulas.reach.timeout", 15) * 60L * 1000L);
        if (success) {
            ra.upload();
        }
        this.addGoalStats(this.getGoalType().toString() + ".analysisTerminated", success ? 1 : 0);
        this.addGoalStats(this.getGoalType().toString() + ".entryPoints", this.getEntryPoints().size());
        this.addGoalStats(this.getGoalType().toString() + ".classpathLength", ra.getAppClasspath().split(System.getProperty("path.separator")).length + ra.getDependencyClasspath().split(System.getProperty("path.separator")).length);
        this.addGoalStats(this.getGoalType().toString() + ".callgraphNodes", ra.getNodeCount());
        this.addGoalStats(this.getGoalType().toString() + ".callgraphEdges", ra.getEdgeCount());
        this.addGoalStats(this.getGoalType().toString(), ra.getStatistics());
    }

    protected final void cleanAfterExecution() {
        if (this.getConfiguration().getConfiguration().getBoolean("vulas.reach.preprocessDependencies", true)) {
            log.info((Object)("Deleting [" + this.rewrittenJars.size() + "] temporary (pre-processed) dependencies..."));
            for (Path p : this.rewrittenJars) {
                try {
                    boolean ret = p.toFile().delete();
                    if (ret) {
                        log.info((Object)("    Deleted temporary (pre-processed) dependency [" + p + "] "));
                        continue;
                    }
                    log.warn((Object)("    Cannot delete temporary (pre-processed) dependency [" + p + "]"));
                }
                catch (Exception ioe) {
                    log.error((Object)("    Cannot delete temporary (pre-processed) dependency [" + p + "]: " + ioe.getMessage()));
                }
            }
        }
    }
}

