/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.sap.psr.vulas.ConstructId;
import com.sap.psr.vulas.FileAnalysisException;
import com.sap.psr.vulas.cg.NodeMetaInformation;
import com.sap.psr.vulas.java.JarAnalyzer;
import com.sap.psr.vulas.java.JavaClassId;
import com.sap.psr.vulas.java.JavaConstructorId;
import com.sap.psr.vulas.java.JavaId;
import com.sap.psr.vulas.monitor.ClassPoolUpdater;
import com.sap.psr.vulas.monitor.ClassVisitor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Callgraph {
    private static final Log log = LogFactory.getLog(Callgraph.class);
    private int nodeCount = 0;
    private int edgeCount = 0;
    private Graph<Integer> idgraph = SlowSparseNumberedGraph.make();
    private final HashMap<com.sap.psr.vulas.shared.json.model.ConstructId, Integer> nodeMap = new HashMap();
    private final HashMap<Integer, NodeMetaInformation> nodeInfoMap = new HashMap();
    private final HashMap<URL, JarAnalyzer> jarAnalyzersCache = new HashMap();
    private final Map<JavaId, URL> cachedJarUrls = new HashMap<JavaId, URL>();
    private final Set<com.sap.psr.vulas.shared.json.model.ConstructId> constructsWithoutJarUrl = new HashSet<com.sap.psr.vulas.shared.json.model.ConstructId>();
    private final ArrayList<com.sap.psr.vulas.shared.json.model.ConstructId> nodeId = new ArrayList();

    public Graph<Integer> getGraph() {
        return this.idgraph;
    }

    public int getIdForConstruct(com.sap.psr.vulas.shared.json.model.ConstructId _c) {
        Integer i = this.nodeMap.get(_c);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public boolean existsInCallgraph(com.sap.psr.vulas.shared.json.model.ConstructId _c) {
        return this.getIdForConstruct(_c) != -1;
    }

    public ArrayList<com.sap.psr.vulas.shared.json.model.ConstructId> getNodeId() {
        return this.nodeId;
    }

    public com.sap.psr.vulas.shared.json.model.ConstructId getConstructForId(int _id) {
        return this.nodeId.get(_id);
    }

    public Callgraph(Graph<com.sap.psr.vulas.shared.json.model.ConstructId> _g) {
        if (_g != null) {
            if (!this.cachedJarUrls.isEmpty()) {
                log.warn((Object)"JAR URL cache not empty, clearing now...");
                this.cachedJarUrls.clear();
            }
            if (!this.jarAnalyzersCache.isEmpty()) {
                log.warn((Object)"JarAnalyzer cache not empty, clearing now ...");
                this.jarAnalyzersCache.clear();
            }
            Iterator iter = _g.iterator();
            com.sap.psr.vulas.shared.json.model.ConstructId src_node = null;
            com.sap.psr.vulas.shared.json.model.ConstructId tgt_node = null;
            Iterator succNodes = null;
            Integer src_id = null;
            Integer tgt_id = null;
            Integer count = -1;
            while (iter.hasNext()) {
                ++this.nodeCount;
                src_node = (com.sap.psr.vulas.shared.json.model.ConstructId)iter.next();
                src_id = this.nodeMap.get(src_node);
                if (src_id == null) {
                    src_id = count = Integer.valueOf(count + 1);
                    this.nodeMap.put(src_node, src_id);
                    this.nodeInfoMap.put(src_id, this.createNodeMetaInformation(src_node, src_id));
                    this.nodeId.add(src_node);
                    this.idgraph.addNode((Object)src_id);
                }
                succNodes = _g.getSuccNodes((Object)src_node);
                while (succNodes.hasNext()) {
                    ++this.edgeCount;
                    tgt_node = (com.sap.psr.vulas.shared.json.model.ConstructId)succNodes.next();
                    tgt_id = this.nodeMap.get(tgt_node);
                    if (tgt_id == null) {
                        tgt_id = count = Integer.valueOf(count + 1);
                        this.nodeMap.put(tgt_node, tgt_id);
                        this.nodeInfoMap.put(tgt_id, this.createNodeMetaInformation(tgt_node, tgt_id));
                        this.nodeId.add(tgt_node);
                        this.idgraph.addNode((Object)tgt_id);
                    }
                    this.idgraph.addEdge((Object)src_id, (Object)tgt_id);
                }
            }
            log.info((Object)("Built Graph<Integer> of " + this.idgraph.getNumberOfNodes() + " nodes"));
        }
    }

    private NodeMetaInformation createNodeMetaInformation(com.sap.psr.vulas.shared.json.model.ConstructId target, Integer target_id) {
        URL jar_url = this.collectArchiveInformation(target);
        String archiveID = null;
        if (jar_url != null && jar_url.toString().startsWith("file:")) {
            archiveID = this.getShaFromCachedJarAnalyzer(jar_url);
        } else {
            jar_url = null;
        }
        return new NodeMetaInformation(target, this.parseNonStaticInnerClassConstruct(target), jar_url, archiveID);
    }

    public NodeMetaInformation getInformationForConstructId(com.sap.psr.vulas.shared.json.model.ConstructId target) {
        return this.nodeInfoMap.get(this.getIdForConstruct(target));
    }

    public Set<com.sap.psr.vulas.shared.json.model.ConstructId> getConstructsWithoutJarUrl() {
        return this.constructsWithoutJarUrl;
    }

    public NodeMetaInformation getInformationForId(Integer id) {
        return this.nodeInfoMap.get(id);
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public Map<com.sap.psr.vulas.shared.json.model.ConstructId, Integer> getDist(com.sap.psr.vulas.shared.json.model.ConstructId _tgt) {
        Map<Integer, Integer> dist = new HashMap<Integer, Integer>();
        int tgt_id = this.nodeMap.get(_tgt);
        Iterator nodes = this.idgraph.iterator();
        while (nodes.hasNext()) {
            int node = (Integer)nodes.next();
            if (node == tgt_id) {
                dist.put(node, 0);
                continue;
            }
            dist.put(node, Integer.MAX_VALUE);
        }
        dist = this.computeDist(tgt_id, dist);
        HashMap<com.sap.psr.vulas.shared.json.model.ConstructId, Integer> result = new HashMap<com.sap.psr.vulas.shared.json.model.ConstructId, Integer>();
        for (Map.Entry<Integer, Integer> entry : dist.entrySet()) {
            result.put(this.nodeId.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private Map<Integer, Integer> computeDist(Integer _tgt, Map<Integer, Integer> _dist) {
        int distance = _dist.get(_tgt) + 1;
        Iterator pred_nodes = this.idgraph.getPredNodes((Object)_tgt);
        while (pred_nodes.hasNext()) {
            Integer prednode = (Integer)pred_nodes.next();
            if (_dist.get(prednode) <= distance) continue;
            _dist.put(prednode, distance);
            _dist = this.computeDist(prednode, _dist);
        }
        return _dist;
    }

    public Map<com.sap.psr.vulas.shared.json.model.ConstructId, LinkedList<Integer>> getShortestPath(com.sap.psr.vulas.shared.json.model.ConstructId _tgt, Set<com.sap.psr.vulas.shared.json.model.ConstructId> _stop_if_path_found) {
        int tgt_id = this.nodeMap.get(_tgt);
        Map<Integer, LinkedList<Integer>> path = new HashMap<Integer, LinkedList<Integer>>();
        Iterator nodes = this.idgraph.iterator();
        while (nodes.hasNext()) {
            int node = (Integer)nodes.next();
            if (node == tgt_id) {
                path.put(node, new LinkedList());
                continue;
            }
            path.put(node, null);
        }
        HashSet<Integer> stop_nodes = null;
        if (_stop_if_path_found != null) {
            stop_nodes = new HashSet<Integer>();
            for (com.sap.psr.vulas.shared.json.model.ConstructId cid : _stop_if_path_found) {
                Integer node_id = this.nodeMap.get(cid);
                if (node_id == null) continue;
                stop_nodes.add(node_id);
            }
        }
        path = this.computeShortestPath(tgt_id, path, stop_nodes);
        HashMap<com.sap.psr.vulas.shared.json.model.ConstructId, LinkedList<Integer>> result = new HashMap<com.sap.psr.vulas.shared.json.model.ConstructId, LinkedList<Integer>>();
        for (Map.Entry<Integer, LinkedList<Integer>> entry : path.entrySet()) {
            result.put(this.nodeId.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private Map<Integer, LinkedList<Integer>> computeShortestPath(Integer _tgt, Map<Integer, LinkedList<Integer>> _paths, Set<Integer> _stop_nodes) {
        LinkedList<Integer> new_path = new LinkedList<Integer>();
        new_path.addAll((Collection)_paths.get(_tgt));
        new_path.add(_tgt);
        int new_path_length = new_path.size();
        Iterator pred_nodes = this.idgraph.getPredNodes((Object)_tgt);
        while (pred_nodes.hasNext()) {
            int prednode = (Integer)pred_nodes.next();
            if (_paths.get(prednode) != null && _paths.get(prednode).size() <= new_path_length) continue;
            _paths.put(prednode, new_path);
            if (_stop_nodes != null && this.existsPath(_paths, _stop_nodes)) continue;
            _paths = this.computeShortestPath(prednode, _paths, _stop_nodes);
        }
        return _paths;
    }

    private final boolean existsPath(Map<Integer, LinkedList<Integer>> _paths, Set<Integer> _nodes) {
        for (Integer n : _nodes) {
            if (!_paths.containsKey(n) || _paths.get(n) == null || _paths.get(n).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private synchronized URL collectArchiveInformation(com.sap.psr.vulas.shared.json.model.ConstructId tgt_node) {
        URL url = null;
        JavaId jid = ((JavaId)JavaId.toCoreType((com.sap.psr.vulas.shared.json.model.ConstructId)tgt_node)).getCompilationUnit();
        if (jid != null) {
            if (!this.cachedJarUrls.containsKey(jid)) {
                url = jid.getJarUrl();
                this.cachedJarUrls.put(jid, url);
                if (url == null) {
                    this.constructsWithoutJarUrl.add(tgt_node);
                }
            }
            url = this.cachedJarUrls.get(jid);
        }
        return url;
    }

    private com.sap.psr.vulas.shared.json.model.ConstructId parseNonStaticInnerClassConstruct(com.sap.psr.vulas.shared.json.model.ConstructId target) {
        boolean is_nested_class;
        JavaId target_jid = (JavaId)JavaId.toCoreType((com.sap.psr.vulas.shared.json.model.ConstructId)target);
        JavaId comp_unit = target_jid.getCompilationUnit();
        boolean bl = is_nested_class = comp_unit instanceof JavaClassId && ((JavaClassId)comp_unit).isNestedClass();
        if (target_jid instanceof JavaConstructorId && is_nested_class) {
            CtClass declaringClass = null;
            CtClass clazz = null;
            try {
                ClassPool cp = ClassPoolUpdater.getInstance().getCustomClassPool();
                if (cp == null) {
                    cp = ClassPool.getDefault();
                }
                String param_to_skip = (declaringClass = (clazz = cp.get(comp_unit.getQualifiedName())).getDeclaringClass()) != null && !Modifier.isStatic((int)clazz.getModifiers()) ? ClassVisitor.removePackageContext((String)declaringClass.getName()) : null;
                com.sap.psr.vulas.shared.json.model.ConstructId result = JavaId.toSharedType((ConstructId)JavaId.parseConstructorQName((JavaId.Type)comp_unit.getType(), (String)ClassVisitor.removeParameterQualification((String)target.getQname()), (String)param_to_skip));
                return result.getQname().contentEquals(target.getQname()) ? null : result;
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private synchronized String getShaFromCachedJarAnalyzer(URL _jar_url) {
        JarAnalyzer ja;
        if (!this.jarAnalyzersCache.containsKey(_jar_url)) {
            ja = null;
            try {
                URI uri = _jar_url.toURI();
                File file = Paths.get(uri).toFile();
                ja = new JarAnalyzer();
                ja.analyze(file);
            }
            catch (InvalidPathException ex) {
                log.error((Object)("Invalid path [" + _jar_url + "]: " + ex.getMessage()), (Throwable)ex);
            }
            catch (FileAnalysisException ex) {
                log.error((Object)("Error analyzing the JAR at [" + _jar_url + "]: " + ex.getMessage()), (Throwable)ex);
            }
            catch (FileSystemNotFoundException fsnfe) {
                log.error((Object)("File system not found for [" + _jar_url + "]: " + fsnfe.getMessage()), (Throwable)fsnfe);
            }
            catch (URISyntaxException e) {
                log.error((Object)("URI syntax exception for [" + _jar_url + "]: " + e.getMessage()), (Throwable)e);
            }
            this.jarAnalyzersCache.put(_jar_url, ja);
        }
        if ((ja = this.jarAnalyzersCache.get(_jar_url)) != null) {
            return ja.getSHA1();
        }
        return null;
    }
}

