/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.sap.psr.vulas.cg.Callgraph;
import com.sap.psr.vulas.cg.ReachabilityAnalyzer;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.StopWatch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallgraphPathSearch
implements Runnable {
    private static final Log log = LogFactory.getLog(CallgraphPathSearch.class);
    private Callgraph graph = null;
    private boolean shortestPaths = true;
    private Set<ConstructId> entrypoints;
    private Set<ConstructId> targetpoints;
    private ArrayList<List<ConstructId>> paths = new ArrayList();
    private String label = null;
    private StopWatch sw = null;
    private ReachabilityAnalyzer analyzer = null;

    public CallgraphPathSearch setCallgraph(Callgraph _g) {
        this.graph = _g;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public CallgraphPathSearch setLabel(String _label) {
        this.label = _label;
        return this;
    }

    public CallgraphPathSearch setShortestPaths(boolean shortestPaths) {
        this.shortestPaths = shortestPaths;
        return this;
    }

    public CallgraphPathSearch setEntrypoints(Set<ConstructId> entrypoints) {
        this.entrypoints = entrypoints;
        return this;
    }

    public CallgraphPathSearch setTargetpoints(Set<ConstructId> targetpoints) {
        this.targetpoints = targetpoints;
        return this;
    }

    public CallgraphPathSearch setCallback(ReachabilityAnalyzer _analyzer) {
        this.analyzer = _analyzer;
        return this;
    }

    @Override
    public void run() {
        this.sw = new StopWatch(this.label + ": Search for paths from [" + this.entrypoints.size() + "] entry points to [" + this.targetpoints.size() + "] target points");
        this.sw.start();
        HashSet<ConstructId> reachable_target_points = new HashSet<ConstructId>();
        for (ConstructId cid : this.targetpoints) {
            if (this.graph.existsInCallgraph(cid)) {
                log.info((Object)("Target construct [" + cid.getQname() + "] is part of the callgraph"));
                Map<ConstructId, Integer> distance = this.graph.getDist(cid);
                for (ConstructId ep : this.entrypoints) {
                    if (!this.graph.existsInCallgraph(ep) || distance.get(ep) == Integer.MAX_VALUE) continue;
                    reachable_target_points.add(cid);
                    break;
                }
                if (!reachable_target_points.contains(cid)) continue;
                Map<ConstructId, LinkedList<Integer>> searched_paths = null;
                if (this.shortestPaths) {
                    log.info((Object)("Searching the shortest path(s) to [" + cid.getQname() + "]"));
                    searched_paths = this.graph.getShortestPath(cid, null);
                } else {
                    log.info((Object)("Searching a path to [" + cid.getQname() + "], stopping after first hit"));
                    searched_paths = this.graph.getShortestPath(cid, this.entrypoints);
                }
                for (ConstructId ep : this.entrypoints) {
                    LinkedList<Integer> spath;
                    if (!this.graph.existsInCallgraph(ep) || (spath = searched_paths.get(ep)) == null) continue;
                    log.info((Object)("Shortest path from entrypoint [ " + ep.getQname() + " ] with distance " + spath.size()));
                    LinkedList<ConstructId> newpath = new LinkedList<ConstructId>();
                    newpath.add(ep);
                    for (int n = spath.size() - 1; n >= 0; --n) {
                        log.info((Object)("        \t\t===>   " + this.graph.getConstructForId(spath.get(n)).getQname()));
                        newpath.add(this.graph.getConstructForId(spath.get(n)));
                    }
                    this.paths.add(newpath);
                }
                continue;
            }
            log.info((Object)("Target construct [" + cid.getQname() + "] is NOT part of the callgraph"));
        }
        log.info((Object)("Search paths for [" + this.label + "] completed: [" + reachable_target_points.size() + "/" + this.targetpoints.size() + "] constructs are reachable"));
        this.sw.stop();
        if (this.analyzer != null) {
            this.analyzer.callback(this);
        }
    }

    public ArrayList<List<ConstructId>> getPaths() {
        return this.paths;
    }

    public StopWatch getStopWatch() {
        return this.sw;
    }
}

