/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.ibm.wala.util.graph.Graph;
import com.sap.psr.vulas.cg.Callgraph;
import com.sap.psr.vulas.cg.MethodNameFilter;
import com.sap.psr.vulas.cg.NodeMetaInformation;
import com.sap.psr.vulas.cg.ReachabilityAnalyzer;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.StopWatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallgraphReachableSearch
implements Runnable {
    private static final Log log = LogFactory.getLog(CallgraphReachableSearch.class);
    private Callgraph graph = null;
    private boolean findTouchPoints = true;
    private StopWatch sw = null;
    private ReachabilityAnalyzer analyzer = null;
    private Set<ConstructId> appConstructs = null;
    private int min = -1;
    private int max = -1;
    private Map<String, Set<List<NodeMetaInformation>>> touchPoints = new HashMap<String, Set<List<NodeMetaInformation>>>();
    private Map<String, Set<NodeMetaInformation>> reachableConstructs = new HashMap<String, Set<NodeMetaInformation>>();

    public CallgraphReachableSearch setCallgraph(Callgraph _g) {
        this.graph = _g;
        return this;
    }

    public CallgraphReachableSearch setFindTouchPoints(boolean _ft) {
        this.findTouchPoints = _ft;
        return this;
    }

    public CallgraphReachableSearch setCallback(ReachabilityAnalyzer _analyzer) {
        this.analyzer = _analyzer;
        return this;
    }

    public CallgraphReachableSearch setMinMax(int _min, int _max) {
        this.min = _min;
        this.max = _max;
        return this;
    }

    public CallgraphReachableSearch setAppConstructs(Set<ConstructId> _app_constructs) {
        this.appConstructs = _app_constructs;
        return this;
    }

    private void addReachableNode(NodeMetaInformation _node) {
        String sha1 = _node.getArchiveId();
        if (sha1 != null) {
            if (!this.reachableConstructs.containsKey(sha1)) {
                this.reachableConstructs.put(sha1, new HashSet());
            }
            Set<NodeMetaInformation> nodes = this.reachableConstructs.get(sha1);
            nodes.add(_node);
        }
    }

    private void addTouchPoint(NodeMetaInformation _from, NodeMetaInformation _to) {
        String sha1 = _to.getArchiveId();
        if (sha1 != null) {
            if (!this.touchPoints.containsKey(sha1)) {
                this.touchPoints.put(sha1, new HashSet());
            }
            Set<List<NodeMetaInformation>> touch_points = this.touchPoints.get(sha1);
            ArrayList<NodeMetaInformation> touch_point = new ArrayList<NodeMetaInformation>();
            touch_point.add(_from);
            touch_point.add(_to);
            touch_points.add(touch_point);
        }
    }

    @Override
    public void run() {
        if (this.graph != null && this.graph.getGraph() != null) {
            StopWatch sw = null;
            try {
                Graph<Integer> wala_graph = this.graph.getGraph();
                Iterator wala_graph_iterator = wala_graph.iterator();
                if (wala_graph_iterator == null) {
                    log.error((Object)("No iterator for callgraph [" + wala_graph + "]"));
                } else {
                    Integer successor_node = null;
                    Iterator successor_nodes_iterator = null;
                    NodeMetaInformation current_node_metainf = null;
                    NodeMetaInformation successor_node_metainf = null;
                    String current_node_qname = null;
                    sw = new StopWatch("Collect touch points and reachable constructs per library, nodes [" + this.min + " - " + this.max + "]").setTotal((double)(this.max - this.min)).start();
                    for (int current_node = this.min; current_node < this.max; ++current_node) {
                        try {
                            current_node_metainf = this.graph.getInformationForId(current_node);
                            if (current_node_metainf != null) {
                                current_node_qname = current_node_metainf.getConstructId().getQname();
                                if (MethodNameFilter.getInstance().isLibraryMethod(this.appConstructs, current_node_qname)) {
                                    if (!MethodNameFilter.getInstance().isBlackListed(current_node_qname)) {
                                        this.addReachableNode(current_node_metainf);
                                    }
                                } else if (this.findTouchPoints) {
                                    successor_nodes_iterator = wala_graph.getSuccNodes((Object)current_node);
                                    while (successor_nodes_iterator.hasNext()) {
                                        successor_node = (Integer)successor_nodes_iterator.next();
                                        successor_node_metainf = this.graph.getInformationForId(successor_node);
                                        String succ_node_qname = successor_node_metainf.getConstructId().getQname();
                                        if (!MethodNameFilter.getInstance().isLibraryMethod(this.appConstructs, succ_node_qname) || MethodNameFilter.getInstance().isBlackListed(succ_node_qname)) continue;
                                        this.addTouchPoint(current_node_metainf, successor_node_metainf);
                                    }
                                }
                            }
                            sw.progress();
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)(e.getClass().getSimpleName() + " occured when looping callgraph node " + current_node_metainf + ": " + e.getMessage()));
                        }
                    }
                    sw.stop();
                }
            }
            catch (NullPointerException npe) {
                sw.stop((Exception)npe);
                log.error((Object)(npe.getClass().getSimpleName() + " occured when looping callgraph"), (Throwable)npe);
            }
            catch (Exception e) {
                sw.stop(e);
                log.error((Object)(e.getClass().getSimpleName() + " occured when looping callgraph: " + e.getMessage()));
            }
        }
    }

    public Map<String, Set<List<NodeMetaInformation>>> getTouchPoints() {
        return this.touchPoints;
    }

    public Map<String, Set<NodeMetaInformation>> getReachableConstructs() {
        return this.reachableConstructs;
    }
}

