/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.ibm.wala.util.graph.Graph;
import com.sap.psr.vulas.cg.AbstractGetPaths;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DepthFirstGetPaths
extends AbstractGetPaths {
    private static final Log log = LogFactory.getLog(DepthFirstGetPaths.class);
    private long start_millis = System.currentTimeMillis();
    private long end_millis = System.currentTimeMillis();

    public DepthFirstGetPaths(Graph<Integer> _graph, ArrayList<ConstructId> _nodeid) {
        super(_graph, _nodeid);
    }

    @Override
    public HashSet<LinkedList<ConstructId>> getAllPaths(ConstructId _src, ConstructId _tgt) {
        this.start_millis = System.currentTimeMillis();
        HashSet<LinkedList<Integer>> paths = new HashSet<LinkedList<Integer>>();
        Integer currentNode = this.nodeId.indexOf(_src);
        LinkedList<Integer> visited = new LinkedList<Integer>();
        visited.add(currentNode);
        this.findAllPaths(visited, paths, currentNode, this.nodeId.indexOf(_tgt));
        HashSet<LinkedList<ConstructId>> result = new HashSet<LinkedList<ConstructId>>();
        for (LinkedList<Integer> p : paths) {
            LinkedList newp = new LinkedList();
            for (Integer i : p) {
                newp.add(this.nodeId.get(i));
            }
            result.add(newp);
        }
        return result;
    }

    private void findAllPaths(LinkedList<Integer> visited, HashSet<LinkedList<Integer>> paths, Integer currentNode, Integer _tgt) {
        if (currentNode == _tgt) {
            LinkedList<Integer> newpath = new LinkedList<Integer>();
            newpath.addAll(visited);
            paths.add(newpath);
            if (!paths.isEmpty() && paths.size() % 5 == 0) {
                this.end_millis = System.currentTimeMillis();
                log.info((Object)("Found 5 more paths in [ " + (this.end_millis - this.start_millis) + " millisecs ]"));
            }
            return;
        }
        int succnode = -1;
        Iterator nodes = this.graph.getSuccNodes((Object)currentNode);
        while (nodes.hasNext()) {
            succnode = (Integer)nodes.next();
            if (visited.contains(succnode)) continue;
            LinkedList<Integer> temp = new LinkedList<Integer>();
            temp.addAll(visited);
            temp.add(succnode);
            this.findAllPaths(temp, paths, succnode, _tgt);
        }
    }
}

