/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.StringList;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodNameFilter {
    private static Log log = LogFactory.getLog(MethodNameFilter.class);
    private static MethodNameFilter instance = null;
    private StringList classnameBlacklist = null;

    private MethodNameFilter() {
        Configuration cfg = VulasConfiguration.getGlobal().getConfiguration();
        this.classnameBlacklist = new StringList();
        this.classnameBlacklist.addAll(cfg.getStringArray("vulas.reach.blacklist.classes.jre"));
        this.classnameBlacklist.addAll(cfg.getStringArray("vulas.reach.blacklist.classes.custom"));
    }

    public static synchronized MethodNameFilter getInstance() {
        if (instance == null) {
            instance = new MethodNameFilter();
        }
        return instance;
    }

    public boolean isBlackListed(String value) {
        return this.classnameBlacklist.contains(value, StringList.ComparisonMode.STARTSWITH, StringList.CaseSensitivity.CASE_SENSITIVE);
    }

    public boolean isLibraryMethod(Set<ConstructId> app_entries, String value) {
        return !this.isAnAppMethod(app_entries, value);
    }

    public boolean isAnAppMethod(Set<ConstructId> app_entries, String value) {
        if (value.contains("$")) {
            value = value.substring(0, value.indexOf("$"));
        }
        for (ConstructId entry : app_entries) {
            if (!entry.getQname().startsWith(value)) continue;
            return true;
        }
        return false;
    }
}

