/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sap.psr.vulas.shared.json.JacksonUtil;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class NodeMetaInformation {
    private ConstructId originalConstructId = null;
    private ConstructId modifiedConstructId = null;
    private String jarUrl = null;
    private String archiveID = null;
    private List<NodeMetaInformation> attackSurface = null;

    public NodeMetaInformation(ConstructId _originalConstructId, ConstructId _modifiedConstructId, URL _jar_url, String _archiveID) {
        this.originalConstructId = _originalConstructId;
        this.modifiedConstructId = _modifiedConstructId;
        this.jarUrl = _jar_url == null ? null : _jar_url.toString();
        this.archiveID = _archiveID;
    }

    public NodeMetaInformation(ConstructId _originalConstructId) {
        this.originalConstructId = _originalConstructId;
    }

    public void addToList(NodeMetaInformation _rs) {
        if (this.attackSurface == null) {
            this.attackSurface = new ArrayList<NodeMetaInformation>();
        }
        this.attackSurface.add(_rs);
    }

    public int getListSize() {
        return this.attackSurface != null ? this.attackSurface.size() : 0;
    }

    public final int compareTo(NodeMetaInformation _c) {
        return this.getOriginalConstructId().compareTo((Object)_c.getOriginalConstructId());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[oc=").append(this.originalConstructId.getQname());
        if (this.modifiedConstructId != null) {
            b.append(", mc=").append(this.modifiedConstructId.getQname());
        }
        b.append(", jarUrl=").append(this.jarUrl).append("]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getOriginalConstructId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeMetaInformation other = (NodeMetaInformation)obj;
        return this.getOriginalConstructId().equals((Object)other.getOriginalConstructId());
    }

    private ConstructId getOriginalConstructId() {
        return this.originalConstructId;
    }

    public ConstructId getConstructId() {
        return this.modifiedConstructId != null ? this.modifiedConstructId : this.originalConstructId;
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public JsonObject toJSON() {
        return this.toJSON(false);
    }

    public JsonObject toJSON(boolean _addAlsoAttackSurface) {
        JsonObject rootObj = new JsonParser().parse(JacksonUtil.asJsonString((Object)this.getConstructId())).getAsJsonObject();
        if (this.jarUrl != null) {
            rootObj.addProperty("jarUrl", this.jarUrl);
        }
        if (this.archiveID != null) {
            rootObj.addProperty("archiveID", this.archiveID);
        }
        if (_addAlsoAttackSurface && this.getListSize() > 0) {
            JsonArray myArray = new JsonArray();
            for (NodeMetaInformation element : this.attackSurface) {
                JsonObject child = element.toJSON(_addAlsoAttackSurface);
                myArray.add((JsonElement)child);
            }
            rootObj.add("attackSurface", (JsonElement)myArray);
        }
        return rootObj;
    }

    public String getArchiveId() {
        return this.archiveID;
    }
}

