/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathSimilarity {
    private static final Log log = LogFactory.getLog(PathSimilarity.class);
    ArrayList<LinkedList<String>> paths = null;
    HashMap<String, HashSet<Integer>> groupedPaths = null;

    public PathSimilarity(ArrayList<LinkedList<String>> _p) {
        this.paths = _p;
    }

    public void addPath(LinkedList<String> _p) {
        this.paths.add(_p);
    }

    public void groupPathsByJointNode() {
        this.groupedPaths = new HashMap();
        for (int i = 0; i < this.paths.size(); ++i) {
            LinkedList<String> p = this.paths.get(i);
            for (String s : p) {
                if (!this.groupedPaths.containsKey(s)) {
                    HashSet<Integer> tmp = new HashSet<Integer>();
                    tmp.add(i);
                    this.groupedPaths.put(s, tmp);
                    continue;
                }
                this.groupedPaths.get(s).add(i);
            }
        }
    }

    private HashSet<List<String>> overlapPath(LinkedList<String> _path1, LinkedList<String> _path2) {
        LinkedList<String> shortpath = new LinkedList<String>();
        LinkedList<String> longpath = new LinkedList<String>();
        if (_path1.size() >= _path2.size()) {
            shortpath.addAll(_path2);
            longpath.addAll(_path1);
        } else {
            shortpath.addAll(_path1);
            longpath.addAll(_path2);
        }
        HashSet<List<String>> results = new HashSet<List<String>>();
        LinkedList<String> overlap = new LinkedList<String>();
        int length = 1;
        int pointer = 0;
        int i = 0;
        int j = 0;
        while (i < shortpath.size() && j < longpath.size()) {
            String node = (String)shortpath.get(i);
            if (node.equals(longpath.get(j))) {
                overlap.add(node);
                ++i;
                ++j;
                continue;
            }
            if (!overlap.isEmpty()) {
                LinkedList<String> newoverlap = new LinkedList<String>();
                newoverlap.addAll(overlap);
                if (newoverlap.size() > length) {
                    length = newoverlap.size();
                }
                results.add(newoverlap);
                overlap.clear();
                i = pointer;
                continue;
            }
            if (i != shortpath.size() - 1 && j == longpath.size() - 1) {
                pointer = i += length;
                j = 0;
                length = 1;
                continue;
            }
            ++j;
        }
        if (!overlap.isEmpty()) {
            results.add(overlap);
        }
        log.info((Object)("Results: " + results));
        return results;
    }

    public void pathSimilarity(LinkedList<String> _path1, LinkedList<String> _path2) {
        int count = 0;
        HashSet<List<String>> overlaps = this.overlapPath(_path1, _path2);
        for (List<String> sp : overlaps) {
            count += sp.size();
        }
        log.info((Object)("The lengths of two paths are " + _path1.size() + " and " + _path2.size() + " separately; overlapping [ " + count + " nodes ] distributed in [ " + overlaps.size() + " subpaths ]"));
    }
}

