/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.ibm.wala.util.graph.Graph;
import com.sap.psr.vulas.cg.AbstractGetPaths;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrunedGraphGetPaths
extends AbstractGetPaths {
    private static final Log log = LogFactory.getLog(PrunedGraphGetPaths.class);
    private long start_millis = System.currentTimeMillis();
    private long end_millis = System.currentTimeMillis();
    private Map<Integer, HashSet<Integer>> edges = new HashMap<Integer, HashSet<Integer>>();

    public PrunedGraphGetPaths(Graph<Integer> _graph, ArrayList<ConstructId> _nodeid) {
        super(_graph, _nodeid);
    }

    @Override
    public HashSet<LinkedList<ConstructId>> getAllPaths(ConstructId _src, ConstructId _tgt) {
        this.start_millis = System.currentTimeMillis();
        int src_id = this.nodeId.indexOf(_src);
        int tgt_id = this.nodeId.indexOf(_tgt);
        this.getAllEdges(tgt_id);
        this.end_millis = System.currentTimeMillis();
        log.info((Object)("Finished computing all edges in [ " + (this.end_millis - this.start_millis) + " millisecs]"));
        LinkedList<Integer> singlepath = new LinkedList<Integer>();
        HashSet<LinkedList<Integer>> allpaths = new HashSet<LinkedList<Integer>>();
        this.assemblePath(src_id, tgt_id, singlepath, allpaths);
        HashSet<LinkedList<ConstructId>> result = new HashSet<LinkedList<ConstructId>>();
        for (LinkedList<Integer> p : allpaths) {
            LinkedList newp = new LinkedList();
            for (Integer i : p) {
                newp.add(this.nodeId.get(i));
            }
            result.add(newp);
        }
        return result;
    }

    private void assemblePath(Integer _src, Integer _tgt, LinkedList<Integer> _path, HashSet<LinkedList<Integer>> _allpaths) {
        if (_src == _tgt) {
            LinkedList<Integer> newPath = new LinkedList<Integer>();
            newPath.addAll(_path);
            _allpaths.add(newPath);
            _path.removeLast();
            if (!_allpaths.isEmpty() && _allpaths.size() % 5 == 0) {
                this.end_millis = System.currentTimeMillis();
                log.info((Object)("Found 5 more paths in [ " + (this.end_millis - this.start_millis) + " millisecs]"));
            }
            return;
        }
        HashSet<Integer> edges = this.edges.get(_src);
        if (edges != null) {
            for (Integer i : edges) {
                if (_path.contains(i)) continue;
                _path.add(i);
                this.assemblePath(i, _tgt, _path, _allpaths);
            }
        }
        if (_path != null && !_path.isEmpty()) {
            _path.removeLast();
        }
    }

    private void getAllEdges(Integer _tgt) {
        Iterator nodes = this.graph.iterator();
        Integer node = null;
        while (nodes.hasNext()) {
            node = (Integer)nodes.next();
            if (node == _tgt) {
                this.edges.put(node, new HashSet());
                continue;
            }
            this.edges.put(node, null);
        }
        this.computeAllEdges(_tgt);
    }

    private void computeAllEdges(Integer _tgt) {
        Iterator predNodes = this.graph.getPredNodes((Object)_tgt);
        Integer prednode = null;
        while (predNodes.hasNext()) {
            prednode = (Integer)predNodes.next();
            HashSet<Integer> newedge = this.edges.get(prednode);
            if (newedge == null) {
                newedge = new HashSet();
            }
            if (newedge.contains(_tgt)) continue;
            newedge.add(_tgt);
            this.edges.put(prednode, newedge);
            this.computeAllEdges(prednode);
        }
    }
}

