/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.wala.util.graph.Graph;
import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.cg.Callgraph;
import com.sap.psr.vulas.cg.CallgraphConstructException;
import com.sap.psr.vulas.cg.CallgraphPathSearch;
import com.sap.psr.vulas.cg.CallgraphReachableSearch;
import com.sap.psr.vulas.cg.NodeMetaInformation;
import com.sap.psr.vulas.cg.spi.CallgraphConstructorFactory;
import com.sap.psr.vulas.cg.spi.ICallgraphConstructor;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.monitor.ClassPoolUpdater;
import com.sap.psr.vulas.shared.enums.PathSource;
import com.sap.psr.vulas.shared.json.JacksonUtil;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.FileUtil;
import com.sap.psr.vulas.shared.util.StopWatch;
import com.sap.psr.vulas.shared.util.StringUtil;
import com.sap.psr.vulas.shared.util.ThreadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReachabilityAnalyzer
implements Runnable {
    private static final Log log = LogFactory.getLog(ReachabilityAnalyzer.class);
    private static int THREAD_COUNT = 0;
    private Application app_ctx = null;
    private GoalContext goalContext = null;
    private Set<Path> app_classpaths = null;
    private Set<Path> dep_classpaths = null;
    private Set<ConstructId> entrypoints = null;
    private PathSource source = null;
    private boolean strictPolicy = false;
    private Callgraph callgraph = null;
    private Map<String, Set<ConstructId>> targetConstructs = null;
    private String excludedPackages = null;
    private Map<String, Long> stats = new HashMap<String, Long>();
    private Set<ConstructId> appConstructs = null;
    private Map<String, Set<List<NodeMetaInformation>>> touchPoints = new HashMap<String, Set<List<NodeMetaInformation>>>();
    private Map<String, Set<NodeMetaInformation>> reachableConstructs = new HashMap<String, Set<NodeMetaInformation>>();
    private ICallgraphConstructor constructor = null;
    private HashMap<String, List<List<ConstructId>>> rcPaths = new HashMap();
    private static final Runtime runtime = Runtime.getRuntime();

    public Callgraph getCallgraph() {
        return this.callgraph;
    }

    public ReachabilityAnalyzer(GoalContext _ctx) {
        this.goalContext = _ctx;
        this.app_ctx = _ctx.getApplication();
    }

    public void setAppClasspaths(Set<Path> _paths) {
        this.app_classpaths = _paths;
    }

    public String getAppClasspath() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        if (this.app_classpaths != null) {
            for (Path p : this.app_classpaths) {
                if (i++ > 0) {
                    b.append(System.getProperty("path.separator"));
                }
                b.append(p.toString());
            }
        }
        return b.toString();
    }

    public void setDependencyClasspaths(Set<Path> _paths) {
        this.dep_classpaths = _paths;
    }

    public String getDependencyClasspath() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        if (this.dep_classpaths != null) {
            for (Path p : this.dep_classpaths) {
                if (i++ > 0) {
                    b.append(System.getProperty("path.separator"));
                }
                b.append(p.toString());
            }
        }
        return b.toString();
    }

    public void setAppConstructs(Set<ConstructId> _constructs) {
        this.appConstructs = _constructs;
    }

    public void setEntryPoints(Set<ConstructId> _constructs, PathSource _source, boolean _throw_exception) {
        this.entrypoints = _constructs;
        this.source = _source;
        this.strictPolicy = _throw_exception;
    }

    public void setExcludePackages(String _packages) {
        if (_packages != null && !_packages.isEmpty()) {
            this.excludedPackages = _packages;
        }
    }

    public void setTargetConstructs(String _filter) {
        try {
            Map change_lists = BackendConnector.getInstance().getAppBugs(this.goalContext, this.app_ctx, _filter);
            if (change_lists == null || change_lists.size() == 0) {
                if (_filter == null || _filter.equals("")) {
                    log.info((Object)"No change list found, i.e., no target points can be set");
                } else {
                    log.info((Object)("No change list found for bug(s) [" + _filter + "], i.e., no target points can be set"));
                }
            } else {
                log.info((Object)("Found change lists for [" + change_lists.size() + "] bugs, their constructs will be used as target points"));
                this.setTargetConstructs(change_lists);
            }
        }
        catch (BackendConnectionException e) {
            log.error((Object)("Error retrieving change lists from the backend: " + e.getMessage()));
        }
    }

    public void setTargetConstructs(Map<String, Set<ConstructId>> _target_constructs) {
        this.targetConstructs = _target_constructs;
    }

    public void setCallgraphConstructor(String analysisFramework, boolean _is_cli) {
        this.constructor = CallgraphConstructorFactory.buildCallgraphConstructor(analysisFramework, this.app_ctx, _is_cli);
        this.constructor.setVulasConfiguration(this.goalContext.getVulasConfiguration());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Graph<ConstructId> readFromDisk(String _file) {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(_file));){
            Object object = ois.readObject();
            Graph g = (Graph)object;
            log.info((Object)("Read call graph with [" + g.getNumberOfNodes() + "] nodes from [" + _file + "]"));
            Graph graph = g;
            return graph;
        }
        catch (IOException ioe) {
            log.error((Object)("I/O error when reading object from [" + _file + "]: " + ioe.getMessage()), (Throwable)ioe);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)("Class not found when reading object from [" + _file + "]: " + cnfe.getMessage()), (Throwable)cnfe);
        }
        return null;
    }

    private void writeToDisk(String _file, Graph<ConstructId> _g) {
        try {
            Path p = Paths.get(_file, new String[0]);
            FileUtil.createDirectory((Path)p.getParent());
            File f = new File(_file);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));){
                oos.writeObject(_g);
                log.info((Object)("Wrote call graph with [" + _g.getNumberOfNodes() + "] nodes to [" + _file + "]"));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("I/O error when writing object to [" + _file + "]: " + ioe.getMessage()), (Throwable)ioe);
        }
    }

    @Override
    public void run() {
        if (this.entrypoints == null) {
            throw new IllegalStateException("No entry points defined, cannot compute call graph");
        }
        if (this.constructor == null) {
            throw new IllegalStateException("No call graph constructor defined");
        }
        try {
            Graph<ConstructId> g = null;
            if (g == null) {
                this.constructor.setDepClasspath(this.getDependencyClasspath());
                this.constructor.setAppClasspath(this.getAppClasspath());
                this.constructor.setExcludePackages(this.excludedPackages);
                this.constructor.setEntrypoints(this.entrypoints);
                this.constructor.buildCallgraph(this.strictPolicy);
                g = this.constructor.getCallgraph();
                long callgraph_construction_time = this.getConstructionTime() / 1000000L;
                log.info((Object)("Call graph construction time (ms) : " + callgraph_construction_time));
                this.stats.put("cgConstructionTime (ms)", callgraph_construction_time);
            }
            this.callgraph = new Callgraph(g);
            int no_jar_url = 0;
            for (ConstructId cid : this.callgraph.getConstructsWithoutJarUrl()) {
                if (this.entrypoints.contains(cid)) continue;
                log.warn((Object)("[" + StringUtil.padLeft((int)(++no_jar_url), (int)4) + "] Cannot determine archive for construct [" + cid.getQname() + "]; size of class pool is [" + ClassPoolUpdater.getInstance().countClasspathElements() + "]"));
            }
            this.stats.put("callgraphNodesWithoutJar", Long.valueOf(Integer.valueOf(no_jar_url).intValue()));
            if (this.targetConstructs == null || this.targetConstructs.isEmpty()) {
                log.info((Object)"No target points defined, i.e., no vulnerability to check reachability for");
            } else {
                Set<ConstructId> src_ep = this.constructor.getEntrypoints();
                boolean search_shortest = this.goalContext.getVulasConfiguration().getConfiguration().getBoolean("vulas.reach.searchShortest", true);
                StopWatch sw = new StopWatch("Check reachability of change list elements").start();
                int no_threads = ThreadUtil.getNoThreads();
                ExecutorService pool = Executors.newFixedThreadPool(no_threads);
                HashSet<CallgraphPathSearch> searches = new HashSet<CallgraphPathSearch>();
                for (String bug : this.targetConstructs.keySet()) {
                    CallgraphPathSearch search = new CallgraphPathSearch().setEntrypoints(src_ep).setTargetpoints(this.targetConstructs.get(bug)).setLabel(bug).setCallback(this).setShortestPaths(search_shortest).setCallgraph(this.callgraph);
                    searches.add(search);
                    pool.execute(search);
                }
                try {
                    pool.shutdown();
                    while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                        log.info((Object)"Wait for the completion of call graph searches ...");
                    }
                }
                catch (InterruptedException e) {
                    throw new CallgraphConstructException("Interrupt exception", e);
                }
                sw.stop();
                long time_max = 0L;
                long bugs_count = this.targetConstructs == null ? 0 : this.targetConstructs.keySet().size();
                long bugs_reachable = 0L;
                long tp_sum = 0L;
                long tp_min = Long.MAX_VALUE;
                long tp_max = 0L;
                long tp_avg = 0L;
                long shortest_path_sum = 0L;
                long shortest_path_min = Long.MAX_VALUE;
                long shortest_path_max = 0L;
                long shortest_path_avg = 0L;
                long path_count = 0L;
                for (CallgraphPathSearch search : searches) {
                    long dur = search.getStopWatch().getRuntime();
                    long l = time_max = dur > time_max ? dur : time_max;
                    if (this.rcPaths.get(search.getLabel()).size() > 0) {
                        ++bugs_reachable;
                        for (List<ConstructId> l2 : this.rcPaths.get(search.getLabel())) {
                            shortest_path_avg = new Double(Math.abs((double)(shortest_path_sum += (long)l2.size()) / (double)(++path_count))).intValue();
                            shortest_path_min = (long)l2.size() < shortest_path_min ? (long)l2.size() : shortest_path_min;
                            shortest_path_max = (long)l2.size() > shortest_path_max ? (long)l2.size() : shortest_path_max;
                        }
                    }
                    tp_avg = new Double(Math.abs((double)(tp_sum += (long)this.targetConstructs.get(search.getLabel()).size()) / (double)bugs_count)).intValue();
                    tp_min = (long)this.targetConstructs.get(search.getLabel()).size() < tp_min ? (long)this.targetConstructs.get(search.getLabel()).size() : tp_min;
                    tp_max = (long)this.targetConstructs.get(search.getLabel()).size() > tp_max ? (long)this.targetConstructs.get(search.getLabel()).size() : tp_max;
                }
                this.stats.put("bugs", bugs_count);
                this.stats.put("bugsReachable", bugs_reachable);
                this.stats.put("targetPointsMin", tp_min);
                this.stats.put("targetPointsMax", tp_max);
                this.stats.put("targetPointsAvg", tp_avg);
                this.stats.put("shortestPathMin", shortest_path_min);
                this.stats.put("shortestPathMax", shortest_path_max);
                this.stats.put("shortestPathAvg", shortest_path_avg);
            }
            this.identifyTouchPoints();
            this.stats.put("reachableArchives", Long.valueOf(Integer.valueOf(this.reachableConstructs.size()).intValue()));
            this.stats.put("touchedArchives", Long.valueOf(Integer.valueOf(this.touchPoints.size()).intValue()));
            long touch_points = 0L;
            for (Map.Entry<String, Set<List<NodeMetaInformation>>> entry : this.touchPoints.entrySet()) {
                touch_points += (long)entry.getValue().size();
            }
            this.stats.put("touchPointsTotal", touch_points);
        }
        catch (CallgraphConstructException e) {
            log.info((Object)("Call graph cannot be constructed or analyzed, reachability analysis will be interrupted: " + e.getMessage()));
            Thread.currentThread().interrupt();
        }
    }

    private void identifyTouchPoints() {
        boolean identify_touchpoints = this.goalContext.getVulasConfiguration().getConfiguration().getBoolean("vulas.reach.identifyTouchpoints", true);
        if (!identify_touchpoints) {
            log.warn((Object)"Identification of touch points disabled per configuration");
        }
        StopWatch sw = new StopWatch("Identify reachable constructs and touch points").start();
        int no_threads = ThreadUtil.getNoThreads();
        ExecutorService pool = Executors.newFixedThreadPool(no_threads);
        int size = new Double(Math.ceil((double)this.callgraph.getNodeCount() / (double)no_threads)).intValue();
        HashSet<Object> searches = new HashSet<Object>();
        for (int i = 0; i < no_threads; ++i) {
            int n = i * size;
            int max = Math.min((i + 1) * size, this.callgraph.getNodeCount());
            CallgraphReachableSearch search = new CallgraphReachableSearch().setAppConstructs(this.appConstructs).setFindTouchPoints(identify_touchpoints).setCallgraph(this.callgraph).setMinMax(n, max);
            searches.add(search);
            pool.execute(search);
        }
        try {
            pool.shutdown();
            while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.info((Object)"Wait for the completion of call graph searches ...");
            }
            for (CallgraphReachableSearch callgraphReachableSearch : searches) {
                Map<String, Set<NodeMetaInformation>> reachable_constructs = callgraphReachableSearch.getReachableConstructs();
                for (String key : reachable_constructs.keySet()) {
                    if (!this.reachableConstructs.containsKey(key)) {
                        this.reachableConstructs.put(key, new HashSet());
                    }
                    this.reachableConstructs.get(key).addAll((Collection<NodeMetaInformation>)reachable_constructs.get(key));
                }
                Map<String, Set<List<NodeMetaInformation>>> touch_points = callgraphReachableSearch.getTouchPoints();
                for (String key : touch_points.keySet()) {
                    if (!this.touchPoints.containsKey(key)) {
                        this.touchPoints.put(key, new HashSet());
                    }
                    this.touchPoints.get(key).addAll((Collection<List<NodeMetaInformation>>)touch_points.get(key));
                }
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupt exception", (Throwable)e);
        }
        sw.stop();
    }

    public Map<String, Long> getStatistics() {
        return this.stats;
    }

    public long getConstructionTime() {
        return this.constructor == null ? -1L : this.constructor.getConstructionTime();
    }

    public Configuration getConfiguration() {
        return this.constructor == null ? null : this.constructor.getConstructorConfiguration();
    }

    public int getNodeCount() {
        return this.callgraph == null ? -1 : this.callgraph.getNodeCount();
    }

    public int getEdgeCount() {
        return this.callgraph == null ? -1 : this.callgraph.getEdgeCount();
    }

    public static boolean startAnalysis(ReachabilityAnalyzer _ra, long _timeout_ms) throws InterruptedException {
        boolean success = false;
        long start_time = System.currentTimeMillis();
        long runtime = -1L;
        long timeout = -1L;
        long wait = -1L;
        Thread t = new Thread((Runnable)_ra, "vulas-reach-" + ++THREAD_COUNT);
        if (_timeout_ms <= 0L) {
            log.info((Object)("Starting reachability analysis (thread [" + t.getName() + "], no timeout"));
            wait = 900000L;
        } else {
            log.info((Object)("Starting reachability analysis (thread [" + t.getName() + "], timeout after " + StringUtil.formatMinString((long)_timeout_ms) + ")"));
            wait = (long)Math.abs((double)_timeout_ms / 10.0);
        }
        ReachabilityAnalyzer.logMemoryConsumption(true);
        t.start();
        while (t.isAlive()) {
            t.join(wait);
            runtime = System.currentTimeMillis() - start_time;
            long l = timeout = _timeout_ms <= 0L ? -1L : _timeout_ms - runtime;
            if (!t.isAlive()) {
                success = true;
                break;
            }
            if (_timeout_ms > 0L && runtime > _timeout_ms) {
                StackTraceElement[] stack;
                log.warn((Object)("[" + t.getName() + "] reached timeout and will be interrupted"));
                for (StackTraceElement e : stack = t.getStackTrace()) {
                    log.warn((Object)("    " + e.toString()));
                }
                t.interrupt();
                success = false;
                break;
            }
            if (_timeout_ms <= 0L) {
                log.info((Object)("[" + t.getName() + "] runs for " + StringUtil.formatMinString((long)runtime)));
            } else {
                log.info((Object)("[" + t.getName() + "] runs for " + StringUtil.formatMinString((long)runtime) + ", will be interrupted in " + StringUtil.formatMinString((long)timeout)));
            }
            ReachabilityAnalyzer.logMemoryConsumption(true);
        }
        if (success) {
            log.info((Object)("[" + t.getName() + "] terminated successfully after " + StringUtil.formatMinString((long)runtime)));
        } else {
            log.error((Object)("[" + t.getName() + "] terminated w/o success after " + StringUtil.formatMinString((long)runtime)));
        }
        return success;
    }

    private static void logMemoryConsumption(boolean _run_gc) {
        long mem_total = runtime.totalMemory();
        long mem_free = runtime.freeMemory();
        long mem_max = runtime.maxMemory();
        log.info((Object)("Memory stats (used/free/total/max): [" + StringUtil.byteToMBString((long)(mem_total - mem_free)) + "/" + StringUtil.byteToMBString((long)mem_free) + "/" + StringUtil.byteToMBString((long)mem_total) + "/" + StringUtil.byteToMBString((long)mem_max) + "]"));
    }

    synchronized void callback(CallgraphPathSearch _search) {
        this.rcPaths.put(_search.getLabel(), _search.getPaths());
        this.uploadBug(_search.getLabel(), _search.getPaths());
    }

    public synchronized void uploadBug(String _bugid, List<List<ConstructId>> _paths) {
        int max_path = this.goalContext.getVulasConfiguration().getConfiguration().getInt("vulas.reach.maxPathPerChangeListElement", 10);
        HashMap<ConstructId, Integer> counters = new HashMap<ConstructId, Integer>();
        int count = -1;
        JsonParser parser = new JsonParser();
        JsonObject json_app = parser.parse(JacksonUtil.asJsonString((Object)this.app_ctx)).getAsJsonObject();
        JsonArray json_paths = new JsonArray();
        JsonObject json_path = null;
        JsonArray json_path_path = null;
        JsonObject path_node_obj = null;
        counters.clear();
        for (List<ConstructId> path : this.rcPaths.get(_bugid)) {
            ConstructId target_construct = path.get(path.size() - 1);
            count = (counters.get(target_construct) == null ? 0 : (Integer)counters.get(target_construct)) + 1;
            counters.put(target_construct, count);
            if (count > max_path) continue;
            json_path = new JsonObject();
            json_path.add("app", (JsonElement)json_app);
            json_path.addProperty("bug", _bugid);
            json_path.addProperty("source", this.source.toString());
            json_path.addProperty("executionId", "dummy");
            json_path_path = new JsonArray();
            for (ConstructId cid : path) {
                path_node_obj = new JsonObject();
                path_node_obj.add("constructId", parser.parse(JacksonUtil.asJsonString((Object)cid)));
                NodeMetaInformation nmi = this.callgraph.getInformationForConstructId(cid);
                path_node_obj.addProperty("lib", nmi.getArchiveId());
                json_path_path.add((JsonElement)path_node_obj);
            }
            json_path.add("path", (JsonElement)json_path_path);
            json_paths.add((JsonElement)json_path);
        }
        int uploaded_path_count = 0;
        for (ConstructId con : counters.keySet()) {
            if ((Integer)counters.get(con) > max_path) {
                log.warn((Object)("[" + (Integer)counters.get(con) + "] paths lead to construct [" + con + "], only [" + max_path + "] will be uploaded"));
                uploaded_path_count += max_path;
                continue;
            }
            uploaded_path_count += ((Integer)counters.get(con)).intValue();
        }
        log.info((Object)("Upload [" + uploaded_path_count + "] path(s) for bug [" + _bugid + "]: " + (this.rcPaths.get(_bugid).size() == 0 ? "Change list NOT reachable " : "Change list reachable")));
        try {
            BackendConnector.getInstance().uploadPaths(this.goalContext, this.app_ctx, json_paths.toString());
        }
        catch (BackendConnectionException e) {
            log.error((Object)("Error while uploading paths for bug [" + _bugid + "]: " + e.getMessage()));
        }
    }

    private void appendJarName(String _jar_url, StringBuffer _buffer) {
        if (_jar_url != null) {
            if (_buffer.length() > 0) {
                _buffer.append(", ");
            }
            if (_jar_url.indexOf("/") != -1) {
                _buffer.append(_jar_url.substring(_jar_url.indexOf("/") + 1));
            } else {
                _buffer.append(_jar_url);
            }
        }
    }

    public void upload() {
        StringBuffer upload_failed;
        StringBuffer upload_succeeded;
        if (!this.reachableConstructs.isEmpty()) {
            upload_succeeded = new StringBuffer();
            upload_failed = new StringBuffer();
            Set<NodeMetaInformation> nodes = null;
            JsonArray json_constructs = null;
            for (String sha1 : this.reachableConstructs.keySet()) {
                nodes = this.reachableConstructs.get(sha1);
                json_constructs = new JsonArray();
                String jar_url = null;
                for (NodeMetaInformation nmi : nodes) {
                    if (jar_url == null) {
                        jar_url = nmi.getJarUrl();
                    }
                    json_constructs.add((JsonElement)new JsonParser().parse(JacksonUtil.asJsonString((Object)nmi.getConstructId())).getAsJsonObject());
                }
                try {
                    log.info((Object)("Upload [" + nodes.size() + "] reachable construct IDs for library [sha1=" + sha1 + ", jar URL=" + jar_url + "]"));
                    boolean success = BackendConnector.getInstance().uploadReachableConstructs(this.goalContext, this.app_ctx, sha1, json_constructs.toString());
                    if (success) {
                        this.appendJarName(jar_url, upload_succeeded);
                        continue;
                    }
                    this.appendJarName(jar_url, upload_failed);
                }
                catch (BackendConnectionException e) {
                    log.error((Object)("Error while uploading reachable constructs for library [sha1=" + sha1 + ", jar URL=" + jar_url + "]: " + e.getMessage()));
                    this.appendJarName(jar_url, upload_failed);
                }
            }
            log.info((Object)("Upload of reachable constructs succeeded for [" + upload_succeeded + "]"));
            log.warn((Object)("Upload of reachable constructs failed    for [" + upload_failed + "]"));
        }
        if (!this.touchPoints.isEmpty()) {
            upload_succeeded = new StringBuffer();
            upload_failed = new StringBuffer();
            Set<List<NodeMetaInformation>> touch_points = null;
            JsonArray json_tps = null;
            JsonObject json_tp = null;
            NodeMetaInformation from = null;
            NodeMetaInformation to = null;
            for (String sha1 : this.touchPoints.keySet()) {
                touch_points = this.touchPoints.get(sha1);
                json_tps = new JsonArray();
                String jar_url = null;
                for (List<NodeMetaInformation> touch_point : touch_points) {
                    json_tp = new JsonObject();
                    from = touch_point.get(0);
                    to = touch_point.get(1);
                    json_tp.add("from", (JsonElement)new JsonParser().parse(JacksonUtil.asJsonString((Object)from.getConstructId())).getAsJsonObject());
                    json_tp.add("to", (JsonElement)new JsonParser().parse(JacksonUtil.asJsonString((Object)to.getConstructId())).getAsJsonObject());
                    json_tp.addProperty("source", this.source.toString());
                    if (sha1.equals(to.getArchiveId())) {
                        json_tp.addProperty("direction", "A2L");
                        jar_url = to.getJarUrl();
                    } else {
                        json_tp.addProperty("direction", "L2A");
                        jar_url = from.getJarUrl();
                    }
                    json_tps.add((JsonElement)json_tp);
                }
                try {
                    log.info((Object)("Upload [" + touch_points.size() + "] touch points for library [sha1=" + sha1 + ", jar URL=" + jar_url + "]"));
                    boolean success = BackendConnector.getInstance().uploadTouchPoints(this.goalContext, this.app_ctx, sha1, json_tps.toString());
                    if (success) {
                        this.appendJarName(jar_url, upload_succeeded);
                        continue;
                    }
                    this.appendJarName(jar_url, upload_failed);
                }
                catch (BackendConnectionException e) {
                    log.error((Object)("Error while uploading touch points for library [sha1=" + sha1 + ", jar URL=" + jar_url + "]: " + e.getMessage()));
                    this.appendJarName(jar_url, upload_failed);
                }
            }
            log.info((Object)("Upload of touch points succeeded for [" + upload_succeeded + "]"));
            log.warn((Object)("Upload of touch points failed    for [" + upload_failed + "]"));
        }
    }
}

