/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.cg.AbstractReachGoal;
import com.sap.psr.vulas.cg.ReachabilityAnalyzer;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.enums.PathSource;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.ConstructIdUtil;
import java.util.Set;

public class T2CGoal
extends AbstractReachGoal {
    private Set<ConstructId> entryPoints = null;
    private Set<ConstructId> tracedConstructs = null;

    public T2CGoal() {
        super(GoalType.T2C);
    }

    @Override
    protected final Set<ConstructId> getEntryPoints() {
        if (this.entryPoints == null) {
            try {
                this.tracedConstructs = BackendConnector.getInstance().getAppTraces(this.getGoalContext(), this.getApplicationContext());
                String[] filter = this.getConfiguration().getConfiguration().getStringArray("vulas.reach.constructFilter");
                this.entryPoints = !(filter == null || filter.length <= 0 || filter.length == 1 && filter[0].equals("")) ? ConstructIdUtil.filterWithRegex(this.tracedConstructs, (String[])filter) : this.tracedConstructs;
            }
            catch (BackendConnectionException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.entryPoints;
    }

    @Override
    protected final void setEntryPoints(ReachabilityAnalyzer _ra) {
        _ra.setEntryPoints(this.getEntryPoints(), PathSource.T2C, this.getConfiguration().getConfiguration().getBoolean("vulas.reach.exitOnUnknownEntryPoints", false));
    }
}

