/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.cg.spi;

import com.sap.psr.vulas.cg.spi.ICallgraphConstructor;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallgraphConstructorFactory {
    public static ClassLoader classLoaderToFindPlugins = Thread.currentThread().getContextClassLoader();
    private static final Log log = LogFactory.getLog(CallgraphConstructorFactory.class);

    public static ICallgraphConstructor buildCallgraphConstructor(String analysisFramework, Application appContext, boolean useURLClassloader) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (useURLClassloader) {
            classloader = CallgraphConstructorFactory.searchInPluginFolder();
        }
        ServiceLoader<ICallgraphConstructor> loader = ServiceLoader.load(ICallgraphConstructor.class, classloader);
        ICallgraphConstructor cgConstructor = null;
        for (ICallgraphConstructor constructor : loader) {
            if (!constructor.getFramework().equals(analysisFramework)) continue;
            cgConstructor = constructor;
            break;
        }
        if (cgConstructor != null) {
            cgConstructor.setAppContext(appContext);
        } else {
            log.error((Object)("No Callgraph Constructor found for requested framework  [" + analysisFramework + "]"));
        }
        return cgConstructor;
    }

    private static ClassLoader searchInPluginFolder() {
        String pluginFolder = VulasConfiguration.getGlobal().getConfiguration().getString("vulas.reach.cli.plugins.dir");
        Path loc = Paths.get(pluginFolder, new String[0]);
        ArrayList<URL> fileNames = new ArrayList<URL>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(loc);){
            for (Path path : directoryStream) {
                URL fileUrl = path.toUri().toURL();
                if (!fileUrl.getFile().endsWith(".jar")) continue;
                fileNames.add(fileUrl);
                log.debug((Object)("Found JAR file [" + fileUrl.toString() + "] in service folder [" + pluginFolder + "]"));
            }
        }
        catch (IOException ex) {
            log.warn((Object)("Cannot load plugin JARs (with additional call graph constructors) from directory [" + loc.toAbsolutePath() + "]"));
        }
        URL[] urls = new URL[fileNames.size()];
        urls = fileNames.toArray(urls);
        URLClassLoader ucl = new URLClassLoader(urls);
        return ucl;
    }
}

