/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas;

import com.sap.psr.vulas.ConstructId;
import com.sap.psr.vulas.shared.enums.DigestAlgorithm;
import com.sap.psr.vulas.shared.json.JsonBuilder;
import com.sap.psr.vulas.shared.util.DigestUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Construct {
    private static final Log log = LogFactory.getLog(Construct.class);
    private ConstructId id = null;
    private String content;
    private String contentDigest = null;

    public Construct(ConstructId _id, String _content) {
        if (_id == null || _content == null) {
            throw new IllegalArgumentException("Id and content must be provided");
        }
        this.id = _id;
        this.setContent(_content);
    }

    public String getDigest() {
        return this.contentDigest;
    }

    public ConstructId getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String _content) {
        this.content = _content;
        this.contentDigest = DigestUtil.getDigestAsString((String)_content, (Charset)StandardCharsets.UTF_8, (DigestAlgorithm)DigestAlgorithm.MD5);
    }

    public String toJSON() {
        JsonBuilder jb = new JsonBuilder();
        jb.startObject();
        jb.appendObjectProperty("id", this.id.toJSON(), false);
        jb.appendObjectProperty("cd", this.contentDigest);
        jb.endObject();
        return jb.getJson();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentDigest == null ? 0 : this.contentDigest.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Construct other = (Construct)obj;
        if (this.contentDigest == null ? other.contentDigest != null : !this.contentDigest.equals(other.contentDigest)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.id.toString();
    }
}

