/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas;

import com.sap.psr.vulas.Construct;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.shared.enums.ConstructChangeType;
import com.sap.psr.vulas.shared.json.JsonBuilder;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.util.StringUtil;
import com.sap.psr.vulas.sign.Signature;
import com.sap.psr.vulas.sign.SignatureChange;
import com.sap.psr.vulas.sign.SignatureFactory;

public class ConstructChange
implements Comparable<ConstructChange> {
    private Construct def = null;
    private Construct fix = null;
    private Signature defSignature = null;
    private Signature fixSignature = null;
    private SignatureChange signatureChange = null;
    private String commit = null;
    private String committedAt = null;
    private String repo = null;
    private String repoPath = null;

    public ConstructChange(String _repo, String _repo_path, Construct _def, Construct _fix, String _rev, String _time_stamp) {
        if (_def == null && _fix == null) {
            throw new IllegalArgumentException("At least one construct must be provided (defective, fixed or both)");
        }
        this.repo = _repo;
        this.repoPath = _repo_path;
        this.def = _def;
        this.fix = _fix;
        this.commit = _rev != null && _rev.contains(":") ? _rev.substring(0, _rev.indexOf(":") - 1) : _rev;
        this.committedAt = _time_stamp;
        SignatureFactory factory = CoreConfiguration.getSignatureFactory(com.sap.psr.vulas.ConstructId.toSharedType(_def != null ? _def.getId() : _fix.getId()));
        if (factory != null) {
            this.defSignature = factory.createSignature(this.def);
            this.fixSignature = factory.createSignature(this.fix);
            this.signatureChange = factory.computeChange(this.def, this.fix);
        }
    }

    public String getRepo() {
        return this.repo;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public String getCommittedAt() {
        return this.committedAt;
    }

    public boolean hasSignatureChange() {
        return this.signatureChange != null && !this.signatureChange.isEmpty();
    }

    public ConstructChangeType getType() {
        if (this.def == null) {
            return ConstructChangeType.ADD;
        }
        if (this.fix == null) {
            return ConstructChangeType.DEL;
        }
        return ConstructChangeType.MOD;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getType().toString());
        buffer.append(" ");
        buffer.append(this.getConstruct());
        buffer.append(System.getProperty("line.separator"));
        if (this.fixSignature != null) {
            buffer.append("F_AST :" + this.fixSignature.toJson() + System.getProperty("line.separator"));
            buffer.append(System.getProperty("line.separator"));
        }
        if (this.defSignature != null) {
            buffer.append("D_AST :" + this.defSignature.toJson());
            buffer.append(System.getProperty("line.separator"));
        }
        if (this.signatureChange != null) {
            buffer.append(System.getProperty("line.separator") + "AST_Diff_json  : " + this.signatureChange.toJSON());
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }

    public String toJSON() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        b.append(" \"repo\" : \"").append(this.repo).append("\",");
        if (this.repoPath != null) {
            b.append(" \"repoPath\" : \"").append(this.repoPath).append("\",");
        }
        b.append(" \"constructId\" : ").append(this.getConstruct().getId().toJSON()).append(",");
        if (this.commit != null) {
            b.append(" \"commit\" : \"").append(this.commit).append("\",");
        }
        b.append(" \"constructChangeType\":\"").append(this.getType().toString()).append("\",");
        if (this.committedAt != null) {
            b.append(" \"committedAt\" : \"").append(StringUtil.formatDate((long)Long.parseLong(this.getCommittedAt()))).append("\"");
        }
        if (this.getType() == ConstructChangeType.MOD) {
            if (this.fixSignature != null) {
                b.append(",\"fixedBody\":").append(JsonBuilder.escape((String)this.fixSignature.toJson().toString()));
            }
            if (this.defSignature != null) {
                b.append(",\"buggyBody\":").append(JsonBuilder.escape((String)this.defSignature.toJson().toString()));
            }
            if (this.signatureChange != null) {
                b.append(",\"bodyChange\":").append(JsonBuilder.escape((String)this.signatureChange.toJSON().toString()));
            }
        }
        b.append("}");
        return b.toString();
    }

    public Construct getConstruct() {
        if (this.getType() == ConstructChangeType.DEL) {
            return this.def;
        }
        return this.fix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.def != null ? this.def.hashCode() : this.fix.hashCode());
        result = 31 * result + this.commit.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructChange other = (ConstructChange)obj;
        ConstructId tc = this.def != null ? com.sap.psr.vulas.ConstructId.toSharedType(this.def.getId()) : com.sap.psr.vulas.ConstructId.toSharedType(this.fix.getId());
        ConstructId oc = other.def != null ? com.sap.psr.vulas.ConstructId.toSharedType(other.def.getId()) : com.sap.psr.vulas.ConstructId.toSharedType(other.fix.getId());
        return tc.equals((Object)oc) && this.commit.equals(other.commit);
    }

    @Override
    public final int compareTo(ConstructChange _cc) {
        int id_comparison_result = this.getConstruct().getId().compareTo(_cc.getConstruct().getId());
        if (id_comparison_result == 0 && this.commit != null) {
            return this.commit.compareTo(_cc.commit);
        }
        return id_comparison_result;
    }
}

