/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas;

import com.sap.psr.vulas.Construct;
import com.sap.psr.vulas.ConstructId;
import com.sap.psr.vulas.FileAnalysisException;
import com.sap.psr.vulas.FileAnalyzer;
import com.sap.psr.vulas.FileAnalyzerFactory;
import com.sap.psr.vulas.shared.util.DirUtil;
import com.sap.psr.vulas.shared.util.FileSearch;
import com.sap.psr.vulas.shared.util.FileUtil;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirAnalyzer
implements FileAnalyzer {
    private static final Log log = LogFactory.getLog(DirAnalyzer.class);
    private File dir = null;
    private Map<ConstructId, Construct> constructs = null;
    private Set<FileAnalyzer> analyzers = new HashSet<FileAnalyzer>();
    private String[] extensionFilter = null;

    public void setExtensionFilter(String[] _exts) {
        this.extensionFilter = (String[])_exts.clone();
    }

    @Override
    public String[] getSupportedFileExtensions() {
        return new String[0];
    }

    @Override
    public boolean canAnalyze(File _file) {
        return FileUtil.isAccessibleDirectory((File)_file);
    }

    @Override
    public void analyze(File _file) throws FileAnalysisException {
        if (!FileUtil.isAccessibleDirectory((File)_file)) {
            throw new IllegalArgumentException("Expected a directory but got [" + _file + "]");
        }
        this.dir = _file;
        HashMap<String, Integer> count_ext = new HashMap<String, Integer>();
        int total = 0;
        int err = 0;
        Set files = null;
        files = this.extensionFilter != null ? new FileSearch(this.extensionFilter).search(this.dir.toPath().normalize()) : new FileSearch(FileAnalyzerFactory.getSupportedFileExtensions()).search(this.dir.toPath().normalize());
        FileAnalyzer fa = null;
        for (Path file : files) {
            try {
                ++total;
                String ext = FileUtil.getFileExtension((File)file.toFile());
                Integer curr = (Integer)count_ext.get(ext);
                if (curr == null) {
                    curr = 0;
                }
                count_ext.put(ext, curr + 1);
                fa = FileAnalyzerFactory.buildFileAnalyzer(file.toFile());
                if (fa == null) continue;
                this.analyzers.add(fa);
            }
            catch (RuntimeException e) {
                ++err;
                log.error((Object)("Error while analyzing file [" + file.toAbsolutePath() + "]: " + e), (Throwable)e);
            }
        }
        StringBuffer b = new StringBuffer();
        b.append("File analyzers created: [" + total + " total, " + err + " with error]");
        for (Map.Entry entry : count_ext.entrySet()) {
            b.append(", [" + entry.getValue() + " " + (String)entry.getKey() + "]");
        }
        log.info((Object)b.toString());
    }

    @Override
    public Map<ConstructId, Construct> getConstructs() throws FileAnalysisException {
        if (this.constructs == null) {
            this.constructs = new TreeMap<ConstructId, Construct>();
            for (FileAnalyzer fa : this.analyzers) {
                try {
                    this.constructs.putAll(fa.getConstructs());
                }
                catch (RuntimeException e) {
                    log.error((Object)("Error getting constructs from [" + fa + "]: " + e), (Throwable)e);
                }
            }
            log.info((Object)("Constructs found: [" + this.constructs.size() + "]"));
        }
        return this.constructs;
    }

    @Override
    public boolean containsConstruct(ConstructId _id) throws FileAnalysisException {
        return this.getConstructs().containsKey(_id);
    }

    @Override
    public Construct getConstruct(ConstructId _id) throws FileAnalysisException {
        return this.getConstructs().get(_id);
    }

    @Override
    public boolean hasChilds() {
        return this.analyzers != null && !this.analyzers.isEmpty();
    }

    @Override
    public Set<FileAnalyzer> getChilds(boolean _recursive) {
        HashSet<FileAnalyzer> nested_fa = new HashSet<FileAnalyzer>();
        if (!_recursive) {
            nested_fa.addAll(this.analyzers);
        } else {
            for (FileAnalyzer fa : this.analyzers) {
                nested_fa.add(fa);
                Set<FileAnalyzer> nfas = fa.getChilds(true);
                if (nfas == null || nfas.isEmpty()) continue;
                nested_fa.addAll(nfas);
            }
        }
        return nested_fa;
    }

    public static synchronized FileAnalyzer createAnalyzerForArchiveEntry(InputStream _is, String _entry) {
        Path tmp_dir = VulasConfiguration.getGlobal().getTmpDir();
        FileAnalyzer fa = null;
        if (!DirUtil.isBelowDestinationPath((Path)tmp_dir, (String)_entry)) {
            log.warn((Object)("Entry [" + _entry + "] will not be extracted, as it would be outside of destination directory"));
        } else {
            File file = new File(tmp_dir.toFile(), _entry);
            if (file.exists()) {
                log.info((Object)("Exists already: Entry [" + _entry + "] corresponds to [" + file.toPath().toAbsolutePath() + "]"));
                fa = FileAnalyzerFactory.buildFileAnalyzer(file);
            } else {
                boolean dir_exists = file.getParentFile().exists();
                if (!dir_exists && !(dir_exists = file.getParentFile().mkdirs())) {
                    log.error((Object)("Could not create directory [" + file.getParentFile() + "]"));
                }
                if (dir_exists) {
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        BufferedInputStream is2 = new BufferedInputStream(_is);
                        int cc = -1;
                        while ((cc = ((InputStream)is2).read()) >= 0) {
                            fos.write(cc);
                        }
                        fos.flush();
                        log.info((Object)("Extracted entry [" + _entry + "] to [" + file.toPath().toAbsolutePath() + "]"));
                        fa = FileAnalyzerFactory.buildFileAnalyzer(file);
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Error when extracting entry to [" + file.toPath().toAbsolutePath() + "]: " + ioe.getMessage()));
                    }
                }
            }
        }
        return fa;
    }
}

