/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas;

import com.sap.psr.vulas.DirAnalyzer;
import com.sap.psr.vulas.FileAnalysisException;
import com.sap.psr.vulas.FileAnalyzer;
import com.sap.psr.vulas.shared.util.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileAnalyzerFactory {
    private static final Log log = LogFactory.getLog(FileAnalyzerFactory.class);
    private static String[] supportedFileExtensions = null;

    public static synchronized String[] getSupportedFileExtensions() {
        if (supportedFileExtensions == null) {
            HashSet<String> exts = new HashSet<String>();
            ServiceLoader<FileAnalyzer> loader = ServiceLoader.load(FileAnalyzer.class);
            for (FileAnalyzer l : loader) {
                String[] ana_exts;
                for (String ana_ext : ana_exts = l.getSupportedFileExtensions()) {
                    if (exts.contains(ana_ext)) {
                        log.warn((Object)("File extension [" + ana_ext + "] supported multiple times"));
                        continue;
                    }
                    exts.add(ana_ext);
                }
            }
            supportedFileExtensions = new String[exts.size()];
            new ArrayList(exts).toArray(supportedFileExtensions);
        }
        return (String[])supportedFileExtensions.clone();
    }

    public static boolean isSupportedFileExtension(String _ext) {
        return Arrays.asList(FileAnalyzerFactory.getSupportedFileExtensions()).contains(_ext);
    }

    public static final FileAnalyzer buildFileAnalyzer(File _file) throws IllegalArgumentException {
        return FileAnalyzerFactory.buildFileAnalyzer(_file, null);
    }

    public static final FileAnalyzer buildFileAnalyzer(File _file, String[] _exts) throws IllegalArgumentException {
        FileAnalyzer fa = null;
        if (FileUtil.isAccessibleDirectory((File)_file) || FileUtil.isAccessibleFile((Path)_file.toPath())) {
            ServiceLoader<FileAnalyzer> loader = ServiceLoader.load(FileAnalyzer.class);
            for (FileAnalyzer l : loader) {
                if (l.canAnalyze(_file)) {
                    try {
                        fa = l;
                        if (_exts != null && fa instanceof DirAnalyzer) {
                            ((DirAnalyzer)fa).setExtensionFilter(_exts);
                        }
                        fa.analyze(_file);
                    }
                    catch (FileAnalysisException e) {
                        log.error((Object)("Error when creating file analyzer for [" + _file.toString() + "]: " + e.getMessage()), (Throwable)e);
                    }
                }
                if (fa == null) continue;
                break;
            }
        } else {
            throw new IllegalArgumentException("File [" + _file.toString() + "] not found or not readable");
        }
        if (fa == null) {
            log.warn((Object)("No analyzer found for file  [" + _file.toString() + "]"));
        }
        return fa;
    }
}

