/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.EntityNotFoundInBackendException;
import com.sap.psr.vulas.backend.HttpMethod;
import com.sap.psr.vulas.backend.HttpResponse;
import com.sap.psr.vulas.backend.requests.BasicHttpRequest;
import com.sap.psr.vulas.backend.requests.ConditionalHttpRequest;
import com.sap.psr.vulas.backend.requests.HttpRequest;
import com.sap.psr.vulas.backend.requests.HttpRequestList;
import com.sap.psr.vulas.backend.requests.PutLibraryCondition;
import com.sap.psr.vulas.backend.requests.StatusCondition;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.goals.AbstractGoal;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.shared.connectivity.PathBuilder;
import com.sap.psr.vulas.shared.connectivity.Service;
import com.sap.psr.vulas.shared.enums.ConstructChangeType;
import com.sap.psr.vulas.shared.enums.ProgrammingLanguage;
import com.sap.psr.vulas.shared.json.JacksonUtil;
import com.sap.psr.vulas.shared.json.model.AffectedLibrary;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.Artifact;
import com.sap.psr.vulas.shared.json.model.Bug;
import com.sap.psr.vulas.shared.json.model.BugChangeList;
import com.sap.psr.vulas.shared.json.model.ConstructChange;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.json.model.Dependency;
import com.sap.psr.vulas.shared.json.model.Library;
import com.sap.psr.vulas.shared.json.model.Space;
import com.sap.psr.vulas.shared.json.model.Trace;
import com.sap.psr.vulas.shared.json.model.VulnerableDependency;
import com.sap.psr.vulas.shared.json.model.view.Views;
import com.sap.psr.vulas.shared.util.FileSearch;
import com.sap.psr.vulas.shared.util.StringList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BackendConnector {
    private static final Log log = LogFactory.getLog(BackendConnector.class);
    private static BackendConnector instance = null;
    private Map<Application, Map<String, Set<ConstructId>>> cacheBugChangeLists = new HashMap<Application, Map<String, Set<ConstructId>>>();
    private Map<Space, Boolean> cacheSpaceExistanceCheck = new HashMap<Space, Boolean>();
    private Map<Application, Boolean> cacheAppExistanceCheck = new HashMap<Application, Boolean>();
    private Map<Application, Set<Dependency>> cacheAppDependencies = new HashMap<Application, Set<Dependency>>();
    private Map<Application, Set<ConstructId>> cacheAppConstructs = new HashMap<Application, Set<ConstructId>>();
    private static final Pattern pattern = Pattern.compile("\\\"countTotal\\\"\\s*:\\s*([\\d]*)");

    protected BackendConnector() {
    }

    public static synchronized BackendConnector getInstance() {
        if (instance == null) {
            instance = new BackendConnector();
        }
        return instance;
    }

    public void cleanCache() {
        log.info((Object)("Deleting cache: [" + this.cacheBugChangeLists.size() + "] bug change lists, [" + this.cacheAppExistanceCheck.size() + "] app existance"));
        this.cacheBugChangeLists = new HashMap<Application, Map<String, Set<ConstructId>>>();
        this.cacheSpaceExistanceCheck = new HashMap<Space, Boolean>();
        this.cacheAppExistanceCheck = new HashMap<Application, Boolean>();
        this.cacheAppDependencies = new HashMap<Application, Set<Dependency>>();
        this.cacheAppConstructs = new HashMap<Application, Set<ConstructId>>();
    }

    public boolean isSpaceExisting(GoalContext _goal_context, Space _space) throws BackendConnectionException {
        Boolean exists = false;
        if (!this.cacheSpaceExistanceCheck.containsKey(_space)) {
            if (CoreConfiguration.isBackendOffline(_goal_context.getVulasConfiguration())) {
                exists = true;
            } else {
                BasicHttpRequest request = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.space((Space)_space), null);
                request.setGoalContext(_goal_context);
                HttpResponse response = request.send();
                exists = response != null && response.isOk();
            }
            this.cacheSpaceExistanceCheck.put(_space, exists);
        }
        return this.cacheSpaceExistanceCheck.get(_space);
    }

    public Space createSpace(GoalContext _goal_context, Space _space) throws BackendConnectionException {
        BasicHttpRequest r = new BasicHttpRequest(HttpMethod.POST, PathBuilder.spaces(), null);
        r.setGoalContext(_goal_context);
        r.setPayload(JacksonUtil.asJsonString((Object)_space), null, true);
        HttpResponse response = r.send();
        Space created_space = null;
        if (response != null && response.isCreated()) {
            try {
                created_space = (Space)JacksonUtil.asObject((String)response.getBody(), Space.class);
            }
            catch (Exception e) {
                throw new BackendConnectionException("Cannot deseriale the newly created space: " + e.getMessage(), e);
            }
        }
        return created_space;
    }

    public void modifySpace(GoalContext _goal_context, Space _space) throws BackendConnectionException {
        BasicHttpRequest r = new BasicHttpRequest(HttpMethod.PUT, PathBuilder.space((Space)_space), null);
        r.setGoalContext(_goal_context);
        r.setPayload(JacksonUtil.asJsonString((Object)_space), null, true);
        r.send();
    }

    public void cleanSpace(GoalContext _goal_context, Space _space) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clean", "true");
        BasicHttpRequest r = new BasicHttpRequest(HttpMethod.POST, PathBuilder.space((Space)_space), params);
        r.setGoalContext(_goal_context);
        r.send();
    }

    public void deleteSpace(GoalContext _goal_context, Space _space) throws BackendConnectionException {
        BasicHttpRequest r = new BasicHttpRequest(HttpMethod.DELETE, PathBuilder.space((Space)_space), null);
        r.setGoalContext(_goal_context);
        r.send();
    }

    public boolean isAppExisting(GoalContext _goal_context, Application _app) throws BackendConnectionException {
        Boolean exists = false;
        if (!this.cacheAppExistanceCheck.containsKey(_app)) {
            BasicHttpRequest r = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.app((Application)_app), null);
            r.setGoalContext(_goal_context);
            HttpResponse response = r.send();
            exists = response != null && response.isOk();
            this.cacheAppExistanceCheck.put(_app, exists);
        }
        return this.cacheAppExistanceCheck.get(_app);
    }

    public void cleanApp(GoalContext _goal_context, Application _app, boolean _clean_history) throws BackendConnectionException {
        if (this.isAppExisting(_goal_context, _app)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clean", "true");
            params.put("cleanGoalHistory", Boolean.toString(_clean_history));
            BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.app((Application)_app), params);
            req.setGoalContext(_goal_context);
            req.send();
        }
    }

    public void purgeAppVersions(GoalContext _goal_context, Application _app, int _keep) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keep", Integer.toString(_keep));
        params.put("mode", "VERSIONS");
        BasicHttpRequest req = new BasicHttpRequest(HttpMethod.DELETE, PathBuilder.artifact((Application)_app), params);
        req.setGoalContext(_goal_context);
        req.send();
    }

    public void uploadApp(GoalContext _goal_context, Application _app) throws BackendConnectionException {
        String json = JacksonUtil.asJsonString((Object)_app, null, Views.Default.class);
        BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.app((Application)_app), null);
        cond_req.setGoalContext(_goal_context);
        HttpRequestList req_list = new HttpRequestList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skipResponseBody", "true");
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.apps(), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setPayload(json, null, true).setGoalContext(_goal_context));
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.app((Application)_app), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).setPayload(json, null, true).setGoalContext(_goal_context));
        req_list.send();
        this.cleanCache();
    }

    public boolean uploadReachableConstructs(GoalContext _goal_context, Application _app, String _lib_digest, String _json) throws BackendConnectionException {
        if (this.isAppExisting(_goal_context, _app)) {
            BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.appReachableConstructs((Application)_app, (String)_lib_digest), null);
            req.setGoalContext(_goal_context);
            req.setPayload(_json, null, true);
            HttpResponse response = req.send();
            return response == null || response.isOk();
        }
        return false;
    }

    public boolean uploadTouchPoints(GoalContext _goal_context, Application _app, String _lib_digest, String _json) throws BackendConnectionException {
        if (this.isAppExisting(_goal_context, _app)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("skipResponseBody", "true");
            BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.appTouchPoints((Application)_app, (String)_lib_digest), params);
            req.setGoalContext(_goal_context);
            req.setPayload(_json, null, true);
            HttpResponse response = req.send();
            return response == null || response.isOk();
        }
        return false;
    }

    public Set<ConstructId> getAppConstructIds(GoalContext _ctx, Application _app) throws BackendConnectionException {
        if (!this.cacheAppConstructs.containsKey(_app)) {
            boolean app_exists = this.isAppExisting(_ctx, _app);
            HashSet<ConstructId> constructs = new HashSet<ConstructId>();
            if (app_exists) {
                ConstructId[] backend_app_construct_ids;
                BasicHttpRequest r = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appConstructIds((Application)_app), null);
                r.setGoalContext(_ctx);
                String json = r.send().getBody();
                for (ConstructId backend_app_construct_id : backend_app_construct_ids = (ConstructId[])JacksonUtil.asObject((String)json, ConstructId[].class)) {
                    try {
                        constructs.add(backend_app_construct_id);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)("Error while transforming backend to client entity: " + e.getMessage()), (Throwable)e);
                    }
                }
                this.cacheAppConstructs.put(_app, constructs);
                log.info((Object)("[" + backend_app_construct_ids.length + "] app constructs received from backend, [" + constructs.size() + "] transformed to client representation"));
            }
        }
        return this.cacheAppConstructs.get(_app);
    }

    public Map<String, Set<ConstructId>> getAppBugs(GoalContext _ctx, Application _app) throws BackendConnectionException {
        if (!this.cacheBugChangeLists.containsKey(_app)) {
            boolean app_exists = this.isAppExisting(_ctx, _app);
            HashMap changes = new HashMap();
            int construct_count = 0;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("historical", "false");
            if (app_exists) {
                BasicHttpRequest r = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appBugs((Application)_app), params);
                r.setGoalContext(_ctx);
                String json = r.send().getBody();
                Bug[] bugs = (Bug[])JacksonUtil.asObject((String)json, Bug[].class);
                HashSet<ConstructId> changes_set = null;
                ConstructId json_cid = null;
                for (Bug b : bugs) {
                    changes_set = (HashSet<ConstructId>)changes.get(b.getBugId());
                    if (changes_set == null) {
                        changes_set = new HashSet<ConstructId>();
                        changes.put(b.getBugId(), changes_set);
                    }
                    for (ConstructChange cc : b.getConstructChanges()) {
                        json_cid = cc.getConstructId();
                        if (!json_cid.getLang().equals((Object)ProgrammingLanguage.JAVA) || cc.getConstructChangeType().equals((Object)ConstructChangeType.ADD)) continue;
                        changes_set.add(json_cid);
                    }
                    construct_count += changes_set.size();
                }
            }
            log.info((Object)("[" + construct_count + "] constructs for [" + changes.keySet().size() + "] bugs received from backend"));
            this.cacheBugChangeLists.put(_app, changes);
        }
        return this.cacheBugChangeLists.get(_app);
    }

    public Map<String, Set<ConstructId>> getAppBugs(GoalContext _ctx, Application _app, String _filter) throws BackendConnectionException {
        if (_filter == null || _filter.equals("")) {
            return this.getAppBugs(_ctx, _app);
        }
        Map<String, Set<ConstructId>> all_change_lists = this.getAppBugs(_ctx, _app);
        HashMap<String, Set<ConstructId>> filtered_change_list = new HashMap<String, Set<ConstructId>>();
        StringList filter = new StringList();
        filter.addAll(_filter, ",", true);
        for (Map.Entry<String, Set<ConstructId>> entry : all_change_lists.entrySet()) {
            if (!filter.contains(entry.getKey(), StringList.ComparisonMode.EQUALS, StringList.CaseSensitivity.CASE_INSENSITIVE)) continue;
            filtered_change_list.put(entry.getKey(), entry.getValue());
        }
        return filtered_change_list;
    }

    public Set<Dependency> getAppDeps(GoalContext _ctx, Application _app) throws BackendConnectionException {
        if (!this.cacheAppDependencies.containsKey(_app)) {
            HashSet<Dependency> deps = new HashSet<Dependency>();
            boolean app_exists = this.isAppExisting(_ctx, _app);
            if (app_exists) {
                String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appDeps((Application)_app), null).setGoalContext(_ctx).send().getBody();
                Dependency[] deps_array = (Dependency[])JacksonUtil.asObject((String)json, Dependency[].class);
                deps.addAll(Arrays.asList(deps_array));
            }
            this.cacheAppDependencies.put(_app, deps);
            log.info((Object)("[" + deps.size() + "] dependencies for app " + _app + " received from backend"));
        }
        return this.cacheAppDependencies.get(_app);
    }

    public Set<VulnerableDependency> getAppVulnDeps(GoalContext _ctx, Application _app, boolean _include_historical, boolean _include_affected, boolean _include_affected_unconfirmed) throws BackendConnectionException {
        HashSet<VulnerableDependency> vuln_deps = new HashSet<VulnerableDependency>();
        boolean app_exists = this.isAppExisting(_ctx, _app);
        if (app_exists) {
            String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appVulnDeps((Application)_app, (boolean)_include_historical, (boolean)_include_affected, (boolean)_include_affected_unconfirmed), null).setGoalContext(_ctx).send().getBody();
            VulnerableDependency[] vuln_deps_array = (VulnerableDependency[])JacksonUtil.asObject((String)json, VulnerableDependency[].class);
            vuln_deps.addAll(Arrays.asList(vuln_deps_array));
        }
        log.info((Object)("[" + vuln_deps.size() + "] vulnerable dependencies for app " + _app + " received from backend"));
        return vuln_deps;
    }

    public VulnerableDependency[] getVulnDeps(Boolean unconfirmedOnly) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unconfirmedOnly", unconfirmedOnly.toString());
        BasicHttpRequest req = new BasicHttpRequest(HttpMethod.GET, PathBuilder.vulnDeps(), params);
        VulnerableDependency[] vulndeps = (VulnerableDependency[])JacksonUtil.asObject((String)req.send().getBody(), VulnerableDependency[].class);
        return vulndeps;
    }

    public Set<ConstructId> getAppTraces(GoalContext _ctx, @NotNull Application _app) throws BackendConnectionException {
        boolean app_exists = this.isAppExisting(_ctx, _app);
        HashSet<ConstructId> constructs = new HashSet<ConstructId>();
        if (app_exists) {
            Trace[] backend_traces;
            String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appTraces((Application)_app), null).setGoalContext(_ctx).send().getBody();
            for (Trace backend_trace : backend_traces = (Trace[])JacksonUtil.asObject((String)json, Trace[].class)) {
                try {
                    constructs.add(backend_trace.getConstructId());
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Error while transforming backend to client entity: " + e.getMessage()), (Throwable)e);
                }
            }
            log.info((Object)("[" + backend_traces.length + "] traces received from backend, [" + constructs.size() + "] transformed to client representation"));
        }
        return constructs;
    }

    public Set<Dependency> getAppDependencies(GoalContext _ctx, @NotNull Application _app) throws BackendConnectionException {
        boolean app_exists = this.isAppExisting(_ctx, _app);
        HashSet<Dependency> deps = new HashSet<Dependency>();
        if (app_exists) {
            String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.appReachableConstructIds((Application)_app), null).setGoalContext(_ctx).send().getBody();
            Dependency[] backend_deps = null;
            backend_deps = json != null ? (Dependency[])JacksonUtil.asObject((String)json, Dependency[].class) : new Dependency[]{};
            deps.addAll(Arrays.asList(backend_deps));
            log.info((Object)("[" + deps.size() + "] dependencies received from backend"));
        }
        return deps;
    }

    public String getLibrary(String _sha1) throws EntityNotFoundInBackendException {
        HttpResponse response = null;
        try {
            response = new BasicHttpRequest(HttpMethod.GET, PathBuilder.lib((String)_sha1), null).send();
            if (response.isNotFound()) {
                throw new EntityNotFoundInBackendException("Library with SHA1 [" + _sha1 + "] not found in backend");
            }
            return response.getBody();
        }
        catch (BackendConnectionException e) {
            throw new EntityNotFoundInBackendException("Library with SHA1 [" + _sha1 + "] not found in backend");
        }
    }

    public int countLibraryConstructs(String _ja) throws BackendConnectionException {
        int count_existing = -1;
        String http_response = null;
        try {
            http_response = this.getLibrary(_ja);
            Matcher m = pattern.matcher(http_response);
            if (m.find()) {
                count_existing = Integer.parseInt(m.group(1));
            }
        }
        catch (NumberFormatException e) {
            BackendConnectionException bce = new BackendConnectionException("Expected number at JSON property $.countTotal", e);
            bce.setHttpResponseBody(http_response);
            throw bce;
        }
        catch (EntityNotFoundInBackendException e) {
            count_existing = -1;
        }
        return count_existing;
    }

    public synchronized void uploadLibrary(GoalContext _ctx, Library _lib) throws BackendConnectionException {
        String sha1 = _lib.getDigest();
        String json = JacksonUtil.asJsonString((Object)_lib, null, Views.LibDetails.class);
        boolean override = _ctx.getVulasConfiguration().getConfiguration().getBoolean("collector.overrideArchive", false);
        HttpRequestList req_list = new HttpRequestList();
        BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.GET, PathBuilder.lib((String)sha1), null);
        cond_req.setGoalContext(_ctx);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skipResponseBody", "true");
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.libs(), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setPayload(json, null, false).setGoalContext(_ctx));
        if (override) {
            log.info((Object)"collector.overrideArchive is enabled");
            req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.lib((String)sha1), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).setPayload(json, null, false).setGoalContext(_ctx));
        } else if (!_ctx.getVulasConfiguration().getConfiguration().getBoolean("skipKnownArchive", false)) {
            req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.lib((String)sha1), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).addCondition(new PutLibraryCondition(_lib)).setPayload(json, null, false).setGoalContext(_ctx));
        }
        req_list.send();
    }

    public void uploadLibraryFile(String _sha1, Path _file) throws BackendConnectionException {
        try (FileInputStream inputStream = new FileInputStream(_file.toFile());){
            HttpRequestList req_list = new HttpRequestList();
            BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.libupload((String)_sha1));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("skipResponseBody", "true");
            req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.libupload((String)_sha1), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setBinPayload(inputStream, "application/octet-stream"));
            req_list.send();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Cannot find [" + _file.toString() + "]: Check if unknown to Maven and upload will be skipped"));
        }
        catch (IOException e) {
            log.error((Object)("Exception when uploading [" + _file.toString() + "]: " + e.getMessage()));
        }
    }

    public boolean uploadGoalExecution(GoalContext _ctx, AbstractGoal _gexe, boolean _before) throws BackendConnectionException {
        boolean ret = false;
        if (_ctx.getApplication() != null) {
            Application app = _ctx.getApplication();
            if (this.isAppExisting(_ctx, app)) {
                BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.goalExcecution(null, (Space)_ctx.getSpace(), (Application)app, (String)_gexe.getId()), null);
                cond_req.setGoalContext(_ctx);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("skipResponseBody", "true");
                ConditionalHttpRequest post = new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.goalExcecutions(null, (Space)_ctx.getSpace(), (Application)app), params);
                post.setConditionRequest(cond_req);
                post.addCondition(new StatusCondition(404));
                post.setPayload(_gexe.toJson(), null, false);
                post.setGoalContext(_ctx);
                ConditionalHttpRequest put = new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.goalExcecution(null, (Space)_ctx.getSpace(), (Application)app, (String)_gexe.getId()), params);
                put.setConditionRequest(cond_req);
                put.addCondition(new StatusCondition(200));
                put.setPayload(_gexe.toJson(), null, false);
                put.setGoalContext(_ctx);
                HttpRequestList req_list = new HttpRequestList();
                if (_before) {
                    req_list.addRequest(post);
                    req_list.addRequest(put);
                } else {
                    req_list.addRequest(put);
                    req_list.addRequest(post);
                }
                HttpResponse response = req_list.send();
                ret = CoreConfiguration.isBackendReadWrite(_ctx.getVulasConfiguration()) ? response != null && (response.isCreated() || response.isOk()) : true;
            } else {
                log.info((Object)("App " + _ctx.getApplication() + " does not exist in backend, upload of goal execution [" + _gexe.getId() + "] skipped"));
                ret = true;
            }
        } else {
            log.warn((Object)"Upload of space goals not yet implemented");
            ret = false;
        }
        return ret;
    }

    public void uploadTraces(GoalContext _ctx, Application _app, String _json) throws BackendConnectionException {
        if (this.isAppExisting(_ctx, _app)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("skipResponseBody", "true");
            BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.appTraces((Application)_app), params);
            req.setGoalContext(_ctx);
            req.setPayload(_json, null, false);
            req.send();
        } else {
            log.warn((Object)("App " + _app + " does not exist in backend, trace upload skipped"));
        }
    }

    public void uploadPaths(GoalContext _ctx, Application _app, String _json) throws BackendConnectionException {
        if (this.isAppExisting(_ctx, _app)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("skipResponseBody", "true");
            BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.appPaths((Application)_app), params);
            req.setGoalContext(_ctx);
            req.setPayload(_json, null, false);
            req.send();
        } else {
            log.warn((Object)("App " + _app + " does not exist in backend, path upload skipped"));
        }
    }

    public boolean isBugExisting(String _bug) throws BackendConnectionException {
        HttpResponse response = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.bug((String)_bug), null).send();
        return response.isOk();
    }

    public void uploadChangeList(String _bug, String _json) throws BackendConnectionException {
        BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.bug((String)_bug), null);
        HttpRequestList req_list = new HttpRequestList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skipResponseBody", "true");
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.bugs(null), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setPayload(_json, null, false));
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.bug((String)_bug), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).setPayload(_json, null, false));
        req_list.send();
    }

    public void uploadAffectedLibs(String _bugid, String _json) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", "PRE_COMMIT_POM");
        BasicHttpRequest req = new BasicHttpRequest(HttpMethod.POST, PathBuilder.bugAffectedLibs((String)_bugid), params);
        req.setPayload(_json, null, true);
        req.send();
    }

    public void uploadCheckVersionResults(String _bugId, String _json) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", "CHECK_VERSION");
        HttpRequestList req_list = new HttpRequestList();
        BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.bugAffectedLibs((String)_bugId), params);
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.bugAffectedLibs((String)_bugId), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setPayload(_json, null, false));
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.bugAffectedLibs((String)_bugId), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).setPayload(_json, null, false));
        req_list.send();
    }

    public AffectedLibrary[] getBugAffectedLibraries(String _bugId, String _source) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", _source);
        String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.bugAffectedLibs((String)_bugId), params).send().getBody();
        return (AffectedLibrary[])JacksonUtil.asObject((String)json, AffectedLibrary[].class);
    }

    public void deletePatchEvalResults(String _bugId, String _source) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", _source);
        BasicHttpRequest del_req = new BasicHttpRequest(HttpMethod.DELETE, PathBuilder.bugAffectedLibs((String)_bugId), params);
        del_req.setPayload("[]", "application/json", true);
        del_req.send();
    }

    public void uploadPatchEvalResults(String _bugId, String _json, String _source) throws BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("source", _source);
        HttpRequestList req_list = new HttpRequestList();
        BasicHttpRequest cond_req = new BasicHttpRequest(HttpMethod.OPTIONS, PathBuilder.bugAffectedLibs((String)_bugId), params);
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.POST, PathBuilder.bugAffectedLibs((String)_bugId), params).setConditionRequest(cond_req).addCondition(new StatusCondition(404)).setPayload(_json, null, false));
        req_list.addRequest(new ConditionalHttpRequest(HttpMethod.PUT, PathBuilder.bugAffectedLibs((String)_bugId), params).setConditionRequest(cond_req).addCondition(new StatusCondition(200)).setPayload(_json, null, false));
        req_list.send();
    }

    public void batchUpload(GoalContext _ctx) {
        FileSearch fs = new FileSearch(new String[]{"obj"});
        Set objs = fs.search(_ctx.getVulasConfiguration().getDir("vulas.core.uploadDir"));
        for (Path obj : objs) {
            HttpRequest ur = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(obj.toFile()));
                ur = (HttpRequest)ois.readObject();
                ois.close();
                ur.setGoalContext(_ctx);
                ur.send();
            }
            catch (Exception e) {
                log.error((Object)("Exception during batch upload of [" + obj + "] to [" + ur + "]: " + e.getMessage()));
            }
        }
    }

    public BugChangeList getBug(String _bugId) throws BackendConnectionException {
        HttpResponse r = new BasicHttpRequest(HttpMethod.GET, PathBuilder.bug((String)_bugId), null).send();
        String json = r.getBody();
        if (r.getStatus() == 200) {
            BugChangeList bugChangeList = (BugChangeList)JacksonUtil.asObject((String)json, BugChangeList.class);
            log.info((Object)("bug change list for bug " + _bugId + " received from backend"));
            return bugChangeList;
        }
        return null;
    }

    public String getClassLibraryIds(String _className) {
        String json = null;
        try {
            HttpResponse response = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.classesLibraryIds((String)_className), null).send();
            if (response.isOk()) {
                json = response.getBody();
            } else {
                log.info((Object)String.valueOf(response.getStatus()));
            }
        }
        catch (BackendConnectionException ex) {
            log.info((Object)ex);
        }
        return json;
    }

    public synchronized String getAstForQnameInLib(String qString, Boolean _sources, ProgrammingLanguage _lang) {
        String json = null;
        try {
            HttpResponse response = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.astForQnameInLib((String)qString, (Boolean)_sources, (ProgrammingLanguage)_lang), null).send();
            if (response.isOk()) {
                json = response.getBody();
            } else {
                log.info((Object)String.valueOf(response.getStatus()));
            }
        }
        catch (BackendConnectionException ex) {
            log.info((Object)ex);
        }
        return json;
    }

    public synchronized String getSourcesForQnameInLib(String qString) {
        String json = null;
        try {
            HttpResponse response = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.sourcesForQnameInLib((String)qString), null).send();
            if (response.isOk()) {
                json = response.getBody();
            }
        }
        catch (BackendConnectionException ex) {
            log.info((Object)ex);
        }
        return json;
    }

    public synchronized ConstructId[] getArtifactBugConstructsIntersection(String _qString, List<ConstructId> c, String packaging, ProgrammingLanguage lang) throws BackendConnectionException {
        String json = null;
        BasicHttpRequest bhr = new BasicHttpRequest(Service.CIA, HttpMethod.POST, PathBuilder.libConstructIdsIntersect((String)_qString, (String)packaging, (ProgrammingLanguage)lang), null);
        bhr.setPayload(JacksonUtil.asJsonString(c), "application/json", false);
        HttpResponse response = bhr.send();
        ConstructId[] intersection = null;
        if (response.isOk()) {
            json = response.getBody();
            intersection = (ConstructId[])JacksonUtil.asObject((String)json, ConstructId[].class);
        }
        return intersection;
    }

    public String getJarConstructs(String qString) {
        String json = null;
        try {
            HttpResponse response = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.sourcesForQnameInLib((String)qString), null).send();
            if (response.isOk()) {
                json = response.getBody();
            }
        }
        catch (BackendConnectionException ex) {
            log.info((Object)ex);
        }
        return json;
    }

    public synchronized String getAstDiff(String jsonReq) {
        String json = null;
        Object ast = null;
        try {
            BasicHttpRequest bhr = new BasicHttpRequest(Service.CIA, HttpMethod.POST, PathBuilder.constructsDiff(), null);
            bhr.setPayload(jsonReq, "application/json", false);
            HttpResponse response = bhr.send();
            if (response.isOk()) {
                json = response.getBody();
            }
        }
        catch (BackendConnectionException ex) {
            log.error((Object)ex);
        }
        return json;
    }

    public Library[] getBugLibraries(String _bugId) throws BackendConnectionException {
        String json = new BasicHttpRequest(HttpMethod.GET, PathBuilder.bugLibraryVersions((String)_bugId), null).send().getBody();
        Library[] libs = (Library[])JacksonUtil.asObject((String)json, Library[].class);
        log.info((Object)("Libraries for bug " + _bugId + " received from backend"));
        return libs;
    }

    public Artifact[] getAllArtifactsGroupArtifact(String _g, String _a) throws BackendConnectionException {
        String json = null;
        Artifact[] result = null;
        json = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.artifactsGroupVersion((String)_g, (String)_a), null).send().getBody();
        log.info((Object)("artifacts for  " + _g + ":" + _a + " received from backend"));
        if (json != null) {
            result = (Artifact[])JacksonUtil.asObject((String)json, Artifact[].class);
        }
        return result;
    }

    public Artifact getArtifact(String _g, String _a, String _v) throws BackendConnectionException {
        String json = null;
        Artifact result = null;
        json = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.artifactsGAV((String)_g, (String)_a, (String)_v), null).send().getBody();
        if (json != null) {
            result = (Artifact)JacksonUtil.asObject((String)json, Artifact.class);
        }
        return result;
    }

    public synchronized ConstructId[] getArtifactConstructs(String _g, String _a, String _v) throws BackendConnectionException {
        String json = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.artifactsConstruct((String)_g, (String)_a, (String)_v), null).send().getBody();
        return (ConstructId[])JacksonUtil.asObject((String)json, ConstructId[].class);
    }

    public synchronized boolean doesArtifactExist(String _g, String _a, String _v, Boolean _sources, String packaging) throws InterruptedException, BackendConnectionException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (_sources != null && _sources.booleanValue()) {
            params.put("classifier", "sources");
        }
        params.put("packaging", packaging);
        params.put("skipResponseBody", "true");
        HttpResponse r = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.artifactsGAV((String)_g, (String)_a, (String)_v), params).send();
        if (r.getStatus() == 200) {
            return true;
        }
        if (r.getStatus() == 404) {
            return false;
        }
        log.warn((Object)("Got status code [" + r.getStatus() + "], artifact [" + _g + ":" + _a + ":" + _v + "] is considered not being available"));
        return false;
    }

    public String getBugsList(ProgrammingLanguage _l) throws BackendConnectionException {
        String json = new BasicHttpRequest(Service.BACKEND, HttpMethod.GET, PathBuilder.bugs((ProgrammingLanguage)_l), null).send().getBody();
        return json;
    }

    public HttpResponse getJarForLib(String _g, String _a, String _v, Boolean _s, String _d) throws BackendConnectionException {
        BasicHttpRequest b = new BasicHttpRequest(Service.CIA, HttpMethod.GET, PathBuilder.downloadArtifactJars((String)_g, (String)_a, (String)_v, (Boolean)_s), null);
        b.setDir(_d);
        return b.send();
    }

    public String getBugsForLib(String _digest) throws BackendConnectionException {
        String json = new BasicHttpRequest(Service.BACKEND, HttpMethod.GET, PathBuilder.libbugs((String)_digest), null).send().getBody();
        return json;
    }
}

