/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend.requests;

import com.sap.psr.vulas.backend.requests.HttpRequest;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpRequest
implements HttpRequest {
    private static final Log log = LogFactory.getLog(AbstractHttpRequest.class);
    protected long ms = System.nanoTime();
    private String objFile = null;
    protected transient GoalContext context = null;

    protected AbstractHttpRequest() {
    }

    public String getObjectFilename() {
        return this.getFilename() + ".obj";
    }

    public Path getObjectPath() {
        return Paths.get(this.getVulasConfiguration().getDir("vulas.core.uploadDir").toString(), this.getObjectFilename());
    }

    @Override
    public HttpRequest setGoalContext(GoalContext _ctx) {
        this.context = _ctx;
        return this;
    }

    @Override
    public GoalContext getGoalContext() {
        return this.context;
    }

    protected VulasConfiguration getVulasConfiguration() {
        if (this.context != null && this.context.getVulasConfiguration() != null) {
            return this.context.getVulasConfiguration();
        }
        return VulasConfiguration.getGlobal();
    }

    @Override
    public final void saveToDisk() throws IOException {
        this.savePayloadToDisk();
        File obj_file = this.getObjectPath().toFile();
        this.objFile = this.getObjectFilename();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(obj_file));
        oos.writeObject(this);
        oos.close();
        log.info((Object)("Request object written to [" + obj_file + "]"));
    }

    @Override
    public final void loadFromDisk() throws IOException {
        this.loadPayloadFromDisk();
    }

    @Override
    public final void deleteFromDisk() throws IOException {
        if (this.getVulasConfiguration().getConfiguration().getBoolean("vulas.core.upload.deleteAfterSuccess", true)) {
            this.deletePayloadFromDisk();
            if (this.objFile != null) {
                this.getObjectPath().toFile().deleteOnExit();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

