/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend.requests;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.HttpMethod;
import com.sap.psr.vulas.backend.HttpResponse;
import com.sap.psr.vulas.backend.requests.AbstractHttpRequest;
import com.sap.psr.vulas.backend.requests.HttpRequest;
import com.sap.psr.vulas.backend.requests.RequestRepeater;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.shared.connectivity.Service;
import com.sap.psr.vulas.shared.json.JsonBuilder;
import com.sap.psr.vulas.shared.json.JsonSyntaxException;
import com.sap.psr.vulas.shared.util.Constants;
import com.sap.psr.vulas.shared.util.FileUtil;
import com.sap.psr.vulas.shared.util.StringUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicHttpRequest
extends AbstractHttpRequest {
    private static final Log log = LogFactory.getLog(BasicHttpRequest.class);
    private static final long serialVersionUID = 1L;
    private HttpMethod method = null;
    private String path = null;
    private Map<String, String> params = null;
    private Service service = null;
    private transient String payload = null;
    private transient FileInputStream binPayload = null;
    private String contentType = null;
    private String dir = null;
    private String payloadPath = null;
    private transient HttpResponse response = null;
    private boolean checkJson = false;

    public BasicHttpRequest(HttpMethod _method, String _path) {
        this(Service.BACKEND, _method, _path, null);
    }

    public BasicHttpRequest(HttpMethod _method, String _path, Map<String, String> _query_string_params) {
        this(Service.BACKEND, _method, _path, _query_string_params);
    }

    public BasicHttpRequest(Service _service, HttpMethod _method, String _path, Map<String, String> _query_string_params) {
        this.service = _service;
        this.method = _method;
        this.path = _path;
        this.params = _query_string_params;
    }

    public BasicHttpRequest setPayload(String _payload, String _type, boolean _check) throws IllegalArgumentException {
        if (this.method.equals((Object)HttpMethod.POST) || this.method.equals((Object)HttpMethod.PUT) || this.method.equals((Object)HttpMethod.DELETE)) {
            this.payload = _payload;
            this.contentType = _type;
            this.checkJson = _check;
            return this;
        }
        throw new IllegalStateException("Payload only possible for POST, PUT and DELETE, not for [" + (Object)((Object)this.method) + "]");
    }

    public BasicHttpRequest setBinPayload(FileInputStream _payload, String _type) throws IllegalArgumentException {
        if (this.method.equals((Object)HttpMethod.POST)) {
            this.binPayload = _payload;
            this.contentType = _type;
            return this;
        }
        throw new IllegalStateException("Payload only possible for POST not for [" + (Object)((Object)this.method) + "]");
    }

    @Override
    public HttpRequest setGoalContext(GoalContext _ctx) {
        this.context = _ctx;
        return this;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean hasPayload() {
        return this.payload != null && !this.payload.isEmpty();
    }

    private boolean isUploadRequest() {
        return this.method.equals((Object)HttpMethod.POST) || this.method.equals((Object)HttpMethod.PUT);
    }

    @Override
    public HttpResponse send() throws BackendConnectionException {
        if (this.response == null) {
            Exception exception;
            Exception exception2 = exception = this.hasPayload() && this.checkJson ? BasicHttpRequest.checkJson(this.payload) : null;
            if (!this.isUploadRequest() && !CoreConfiguration.isBackendOffline(this.getVulasConfiguration()) || this.isUploadRequest() && exception == null && CoreConfiguration.isBackendReadWrite(this.getVulasConfiguration())) {
                try {
                    this.response = this.sendRequest();
                    if (this.response.isCreated() || this.response.isOk()) {
                        try {
                            this.deleteFromDisk();
                        }
                        catch (IOException e) {
                            log.error((Object)("Error deleting files from update directory: " + e.getMessage()));
                        }
                    }
                }
                catch (BackendConnectionException e) {
                    exception = e;
                    log.error((Object)e.getMessage());
                    try {
                        FileUtil.writeToFile((File)new File(this.getVulasConfiguration().getTmpDir().toFile(), this.getFilename() + ".html"), (String)e.getHttpResponseBody());
                    }
                    catch (IOException e1) {
                        log.error((Object)("Error saving HTTP error message: " + e1.getMessage()), (Throwable)e1);
                    }
                }
            }
            if (!(!this.isUploadRequest() || this.isPayloadSavedOnDisk() || exception == null && CoreConfiguration.isBackendReadWrite(this.getVulasConfiguration()))) {
                try {
                    this.saveToDisk();
                }
                catch (IOException e) {
                    log.info((Object)("HttpUploadRequest could not be saved: " + e.getMessage()));
                }
            }
            if (exception != null) {
                throw new BackendConnectionException(exception.getMessage(), exception);
            }
        }
        return this.response;
    }

    private boolean isPayloadSavedOnDisk() {
        return this.payloadPath != null && Paths.get(this.payloadPath, new String[0]).toFile().exists();
    }

    @Override
    public String getFilename() {
        String prefix = this.path;
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        prefix = prefix.replace("/", "__");
        prefix = prefix.replace("?", "__");
        prefix = this.ms + "-" + prefix;
        return prefix;
    }

    public String getPayloadFilename() {
        return this.getFilename() + ".json";
    }

    @Override
    public void savePayloadToDisk() throws IOException {
        if (this.hasPayload()) {
            Path payload_path = Paths.get(this.getVulasConfiguration().getDir("vulas.core.uploadDir").toString(), this.getPayloadFilename());
            this.payloadPath = payload_path.toString();
            File json_file = payload_path.toFile();
            FileUtil.writeToFile((File)json_file, (String)this.payload);
            log.info((Object)("Request body (JSON) written to [" + json_file + "]"));
        }
    }

    @Override
    public void loadPayloadFromDisk() throws IOException {
        if (this.payloadPath != null) {
            this.payload = FileUtil.readFile((String)this.payloadPath);
        }
    }

    @Override
    public void deletePayloadFromDisk() throws IOException {
        if (this.payloadPath != null) {
            Paths.get(this.payloadPath, new String[0]).toFile().deleteOnExit();
        }
    }

    private final HttpResponse sendRequest() throws BackendConnectionException {
        HttpResponse response = null;
        HttpURLConnection connection = null;
        int response_code = -1;
        URI uri = this.getUri();
        Map<String, List<String>> request_fields = null;
        RequestRepeater repeater = new RequestRepeater(this.getVulasConfiguration().getConfiguration().getLong("vulas.core.repeatHttp.max", 50L), this.getVulasConfiguration().getConfiguration().getLong("vulas.core.repeatHttp.waitMilli", 60000L));
        try {
            boolean is_503;
            do {
                is_503 = false;
                long start_nano = System.nanoTime();
                connection = (HttpURLConnection)uri.toURL().openConnection();
                connection.setRequestMethod(this.method.toString().toUpperCase());
                String tenant_token = null;
                String space_token = null;
                if (this.context != null && this.context.hasTenant()) {
                    tenant_token = this.context.getTenant().getTenantToken();
                    connection.setRequestProperty("X-Vulas-Tenant", tenant_token);
                }
                if (this.context != null && this.context.hasSpace()) {
                    space_token = this.context.getSpace().getSpaceToken();
                    connection.setRequestProperty("X-Vulas-Space", space_token);
                }
                connection.setRequestProperty("X-Vulas-Version", CoreConfiguration.getVulasRelease());
                connection.setRequestProperty("X-Vulas-Component", Constants.VulasComponent.client.toString());
                if (this.hasPayload()) {
                    connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                    connection.setRequestProperty("Content-Length", Integer.toString(this.payload.getBytes().length));
                    connection.setRequestProperty("Content-Language", "en-US");
                } else if (this.binPayload != null) {
                    connection.setRequestProperty("Content-Type", this.contentType);
                }
                if (!this.hasPayload()) {
                    log.info((Object)("HTTP " + this.method.toString().toUpperCase() + " [uri=" + uri + (tenant_token == null ? "" : ", tenant=" + tenant_token) + (space_token == null ? "" : ", space=" + space_token) + "]"));
                } else if (this.binPayload == null) {
                    log.info((Object)("HTTP " + this.method.toString().toUpperCase() + " [uri=" + uri + ", size=" + StringUtil.byteToKBString((long)this.payload.getBytes().length) + (tenant_token == null ? "" : ", tenant=" + tenant_token) + (space_token == null ? "" : ", space=" + space_token) + "]"));
                } else {
                    log.info((Object)("HTTP " + this.method.toString().toUpperCase() + " [uri=" + uri + ", size=" + this.binPayload.available() + (tenant_token == null ? "" : ", tenant=" + tenant_token) + (space_token == null ? "" : ", space=" + space_token) + "]"));
                }
                connection.setUseCaches(false);
                connection.setDoInput(true);
                if (this.hasPayload()) {
                    connection.setDoOutput(true);
                    request_fields = connection.getRequestProperties();
                    DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                    wr.write(this.payload.getBytes("UTF-8"));
                    wr.flush();
                    wr.close();
                } else if (this.binPayload != null) {
                    int length;
                    connection.setDoOutput(true);
                    request_fields = connection.getRequestProperties();
                    OutputStream output = connection.getOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((length = this.binPayload.read(buffer)) > 0) {
                        output.write(buffer, 0, length);
                    }
                    output.flush();
                    output.close();
                } else {
                    connection.setDoOutput(false);
                    request_fields = connection.getRequestProperties();
                    connection.connect();
                }
                response_code = connection.getResponseCode();
                response = new HttpResponse(response_code);
                if (response.isOk() && connection.getContentType() != null && connection.getContentType().contains("application/java-archive")) {
                    String fileName = "";
                    String disposition = connection.getHeaderField("Content-Disposition");
                    if (disposition != null) {
                        int index = disposition.indexOf("filename=");
                        if (index > 0) {
                            fileName = disposition.substring(index + 9, disposition.length());
                        }
                    } else {
                        fileName = this.path.substring(this.path.lastIndexOf("/") + 1, this.path.length());
                    }
                    InputStream inputStream = connection.getInputStream();
                    String saveFilePath = null;
                    if (this.dir != null) {
                        if (!Files.exists(Paths.get(this.dir, new String[0]), new LinkOption[0])) {
                            Files.createDirectories(Paths.get(this.dir, new String[0]), new FileAttribute[0]);
                        }
                        saveFilePath = this.dir + File.separator + fileName;
                    } else {
                        saveFilePath = Paths.get(this.getVulasConfiguration().getTmpDir().toString(), new String[0]).toString() + File.separator + fileName;
                    }
                    FileOutputStream outputStream = new FileOutputStream(saveFilePath);
                    int bytesRead = -1;
                    byte[] buffer = new byte[inputStream.available()];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    response.setBody(saveFilePath);
                    outputStream.close();
                    inputStream.close();
                } else if (response.isOk() || response.isCreated()) {
                    response.setBody(FileUtil.readInputStream((InputStream)connection.getInputStream(), (Charset)FileUtil.getCharset()));
                }
                long end_nano = System.nanoTime();
                log.info((Object)("HTTP " + this.method.toString().toUpperCase() + " completed with response code [" + response_code + "] in " + StringUtil.nanoToFlexDurationString((long)(end_nano - start_nano)) + " (proxy=" + connection.usingProxy() + ")"));
                if (response.isServiceUnavailable()) {
                    is_503 = true;
                    continue;
                }
                if (!response.isServerError() && response.getStatus() != 400) continue;
                BackendConnectionException bce = new BackendConnectionException(this.method, uri, response_code, null);
                try {
                    String body = this.readErrorStream(connection);
                    if (body != null && !body.trim().equals("")) {
                        bce.setHttpResponseBody(body);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw bce;
            } while (repeater.repeat(is_503));
            if (is_503) {
                throw new BackendConnectionException(this.method, uri, 503, null);
            }
        }
        catch (BackendConnectionException bce) {
            this.logHeaderFields("    Request-header", request_fields);
            this.logHeaderFields("    Response-header", connection.getHeaderFields());
            if (bce.getHttpResponseBody() != null) {
                log.error((Object)("    Response-body: [" + bce.getHttpResponseBody().replaceAll("[\\t\\n\\x0B\\f\\r]*", "") + "]"));
            }
            log.error((Object)("    Exception message: [" + bce.getMessage() + "]"));
            if (this.hasPayload()) {
                log.error((Object)("    HTTP Request body: [" + this.payload.toString() + "]"));
            }
        }
        catch (Exception e) {
            BackendConnectionException bce = new BackendConnectionException(this.method, uri, response_code, e);
            try {
                bce.setHttpResponseBody(this.readErrorStream(connection));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw bce;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private void logHeaderFields(String _prefix, Map<String, List<String>> _fields) {
        for (Map.Entry<String, List<String>> entry : _fields.entrySet()) {
            log.error((Object)(_prefix + " " + (entry.getKey() == null ? "" : "[" + entry.getKey() + "] = ") + entry.getValue()));
        }
    }

    private String readErrorStream(HttpURLConnection _c) throws IOException {
        String error = null;
        if (_c != null) {
            InputStream is = _c.getErrorStream();
            if (is == null) {
                is = _c.getInputStream();
            }
            if (is != null) {
                error = FileUtil.readInputStream((InputStream)is, (Charset)FileUtil.getCharset());
            }
        }
        return error;
    }

    private URI getUri() {
        return this.getUri(this.service, this.path, this.params);
    }

    public URI getUri(Service _service, String _path, Map<String, String> _params) {
        if (!CoreConfiguration.isBackendOffline(this.getVulasConfiguration()) && !this.getVulasConfiguration().hasServiceUrl(_service)) {
            throw new IllegalStateException("URL for service [" + _service + "] is not configured");
        }
        URI uri = null;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getVulasConfiguration().getServiceUrl(_service));
        builder.append(_path);
        int i = 0;
        if (_params != null) {
            for (Map.Entry<String, String> entry : _params.entrySet()) {
                if (i == 0) {
                    builder.append('?');
                } else if (i <= _params.size()) {
                    builder.append('&');
                }
                builder.append(entry.getKey()).append('=').append(entry.getValue());
                ++i;
            }
        }
        try {
            if (builder.toString().contains("[") || builder.toString().contains("]")) {
                URL url = new URL(builder.toString());
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            } else {
                uri = new URI(builder.toString());
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error when creating URI out of [" + builder.toString() + "]: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Error when creating URI out of [" + builder.toString() + "]: " + e.getMessage());
        }
        return uri;
    }

    private static final Exception checkJson(String _json) {
        JsonSyntaxException exception = null;
        if (_json != null) {
            try {
                JsonBuilder.checkJsonValidity((String)_json);
            }
            catch (JsonSyntaxException jse) {
                log.error((Object)("Invalid JSON syntax: " + jse.getMessage()));
                exception = jse;
            }
        }
        return exception;
    }

    public String toString() {
        return "HTTP " + this.method.toString().toUpperCase() + " [uri=" + this.getUri() + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.loadFromDisk();
    }
}

