/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend.requests;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.HttpMethod;
import com.sap.psr.vulas.backend.HttpResponse;
import com.sap.psr.vulas.backend.requests.BasicHttpRequest;
import com.sap.psr.vulas.backend.requests.HttpRequest;
import com.sap.psr.vulas.backend.requests.ResponseCondition;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.goals.GoalContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConditionalHttpRequest
extends BasicHttpRequest {
    private static final Log log = LogFactory.getLog(ConditionalHttpRequest.class);
    private List<ResponseCondition> conditions = new LinkedList<ResponseCondition>();
    private BasicHttpRequest conditionRequest = null;

    public ConditionalHttpRequest(HttpMethod _method, String _path, Map<String, String> _query_string_params) {
        super(_method, _path, _query_string_params);
    }

    public ConditionalHttpRequest setConditionRequest(BasicHttpRequest _cr) {
        this.conditionRequest = _cr;
        return this;
    }

    public ConditionalHttpRequest addCondition(ResponseCondition _condition) {
        this.conditions.add(_condition);
        return this;
    }

    @Override
    public HttpRequest setGoalContext(GoalContext _ctx) {
        this.context = _ctx;
        if (this.conditionRequest != null) {
            this.conditionRequest.setGoalContext(_ctx);
        }
        return this;
    }

    @Override
    public HttpResponse send() throws IllegalStateException, BackendConnectionException {
        if (this.conditionRequest == null || this.conditions.size() == 0) {
            throw new IllegalStateException("No condition request or no conditions set");
        }
        if (CoreConfiguration.isBackendOffline(this.getVulasConfiguration())) {
            log.info((Object)("Condition(s) not evaluated due to offline mode, do " + this.toString()));
            return super.send();
        }
        boolean meets = true;
        HttpResponse condition_response = this.conditionRequest.send();
        for (ResponseCondition rc : this.conditions) {
            boolean bl = meets = meets && rc.meetsCondition(condition_response);
            if (!meets) {
                log.debug((Object)("Condition " + rc + " not met"));
                break;
            }
            log.debug((Object)("Condition " + rc + " met"));
        }
        if (meets) {
            log.debug((Object)("Condition(s) met, do " + this.toString()));
            return super.send();
        }
        log.debug((Object)("Condition(s) not met, skip " + this.toString()));
        return null;
    }

    @Override
    public void savePayloadToDisk() throws IOException {
        super.savePayloadToDisk();
        if (this.conditionRequest != null) {
            this.conditionRequest.savePayloadToDisk();
        }
    }

    @Override
    public void loadPayloadFromDisk() throws IOException {
        super.loadPayloadFromDisk();
        if (this.conditionRequest != null) {
            this.conditionRequest.loadPayloadFromDisk();
        }
    }

    @Override
    public void deletePayloadFromDisk() throws IOException {
        super.deletePayloadFromDisk();
        if (this.conditionRequest != null) {
            this.conditionRequest.deletePayloadFromDisk();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        super.loadPayloadFromDisk();
        this.loadPayloadFromDisk();
    }
}

