/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend.requests;

import com.sap.psr.vulas.backend.HttpResponse;
import com.sap.psr.vulas.backend.requests.ResponseCondition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentCondition
implements ResponseCondition {
    private String regex = null;
    private Mode mode = Mode.MATCH;
    private String value = null;
    private Pattern pattern = null;

    public ContentCondition(String _regex, Mode _mode, String _value) {
        this.regex = _regex;
        this.pattern = Pattern.compile(this.regex);
        this.mode = _mode;
        this.value = _value;
    }

    @Override
    public boolean meetsCondition(HttpResponse _response) {
        if (_response == null || !_response.hasBody()) {
            return false;
        }
        boolean meets = false;
        Matcher m = this.pattern.matcher(_response.getBody());
        if (this.mode.equals((Object)Mode.MATCH)) {
            meets = m.matches();
        } else if (this.mode.equals((Object)Mode.EQ_STRING)) {
            meets = m.find() && this.value.equals(m.group(1));
        } else if (this.mode.equals((Object)Mode.LT_DOUBLE)) {
            if (m.find()) {
                double actual = Double.parseDouble(m.group(1));
                meets = actual < Double.parseDouble(this.value);
            }
        } else if (this.mode.equals((Object)Mode.GT_DOUBLE) && m.find()) {
            double actual = Double.parseDouble(m.group(1));
            meets = actual > Double.parseDouble(this.value);
        }
        return meets;
    }

    public String toString() {
        return "[body " + (Object)((Object)this.mode) + " " + this.value + "]";
    }

    public static enum Mode {
        MATCH,
        EQ_STRING,
        LT_DOUBLE,
        GT_DOUBLE;

    }
}

