/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.backend.requests;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.HttpResponse;
import com.sap.psr.vulas.backend.requests.AbstractHttpRequest;
import com.sap.psr.vulas.backend.requests.HttpRequest;
import com.sap.psr.vulas.goals.GoalContext;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequestList
extends AbstractHttpRequest {
    private static final Log log = LogFactory.getLog(HttpRequestList.class);
    private boolean stopOnSuccess = true;
    private List<HttpRequest> list = new LinkedList<HttpRequest>();

    public HttpRequestList() {
        this(true);
    }

    public HttpRequestList(boolean _stop_on_success) {
        this.stopOnSuccess = _stop_on_success;
    }

    public void addRequest(HttpRequest _r) {
        this.list.add(_r);
    }

    @Override
    public HttpRequest setGoalContext(GoalContext _ctx) {
        this.context = _ctx;
        for (HttpRequest r : this.list) {
            r.setGoalContext(_ctx);
        }
        return this;
    }

    @Override
    public HttpResponse send() throws BackendConnectionException {
        HttpResponse response = null;
        for (HttpRequest r : this.list) {
            response = r.send();
            if (!this.stopOnSuccess || response == null || !response.isOk() && !response.isCreated()) continue;
            break;
        }
        return response;
    }

    @Override
    public String getFilename() {
        String prefix = this.ms + "-hrl";
        return prefix;
    }

    @Override
    public void savePayloadToDisk() throws IOException {
        for (HttpRequest r : this.list) {
            r.savePayloadToDisk();
        }
    }

    @Override
    public void loadPayloadFromDisk() throws IOException {
        for (HttpRequest r : this.list) {
            r.loadPayloadFromDisk();
        }
    }

    @Override
    public void deletePayloadFromDisk() throws IOException {
        for (HttpRequest r : this.list) {
            r.deletePayloadFromDisk();
        }
    }
}

