/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.core.util;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.ConstructId;
import com.sap.psr.vulas.shared.json.model.Space;
import com.sap.psr.vulas.shared.json.model.Tenant;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import com.sap.psr.vulas.sign.SignatureFactory;
import java.util.ServiceLoader;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreConfiguration {
    private static final Log log = LogFactory.getLog(CoreConfiguration.class);
    public static final String TENANT_TOKEN = "vulas.core.tenant.token";
    public static final String SPACE_TOKEN = "vulas.core.space.token";
    public static final String SPACE_NAME = "vulas.core.space.name";
    public static final String SPACE_DESCR = "vulas.core.space.description";
    public static final String SPACE_EXPCFG = "vulas.core.space.exportConfiguration";
    public static final String SPACE_PUBLIC = "vulas.core.space.public";
    public static final String SPACE_BUGFLT = "vulas.core.space.bugFilter";
    public static final String SPACE_OWNERS = "vulas.core.space.bugFilter";
    public static final String APP_CTX_GROUP = "vulas.core.appContext.group";
    public static final String APP_CTX_ARTIF = "vulas.core.appContext.artifact";
    public static final String APP_CTX_VERSI = "vulas.core.appContext.version";
    public static final String BACKEND_CONNECT = "vulas.core.backendConnection";
    public static final String UPLOAD_DIR = "vulas.core.uploadDir";
    public static final String UPLOAD_DEL_AFTER = "vulas.core.upload.deleteAfterSuccess";
    public static final String REPEAT_MAX = "vulas.core.repeatHttp.max";
    public static final String REPEAT_WAIT = "vulas.core.repeatHttp.waitMilli";
    public static final String VERIFY_JARS = "vulas.core.verifyJars";
    public static final String JAR_TIMEOUT = "vulas.core.jarAnalysis.timeout";
    public static final String CLEAN_HISTORY = "vulas.core.clean.goalHistory";
    public static final String CLEAN_PURGE_VERSIONS = "vulas.core.clean.purgeVersions";
    public static final String CLEAN_PURGE_KEEP_LAST = "vulas.core.clean.purgeVersions.keepLast";
    public static final String APP_DIRS = "vulas.core.app.sourceDir";
    public static final String APP_PREFIXES = "vulas.core.app.appPrefixes";
    public static final String APP_JAR_NAMES = "vulas.core.app.appJarNames";
    public static final String APP_UPLOAD_EMPTY = "vulas.core.app.uploadEmpty";
    public static final String APP_LIB_UPLOAD = "vulas.core.app.uploadLibrary";
    public static final String REP_AGGR_MODULES = "vulas.report.aggregateModules";
    public static final String REP_EXC_THRESHOLD = "vulas.report.exceptionThreshold";
    public static final String REP_EXC_SCOPE_BL = "vulas.report.exceptionScopeBlacklist";
    public static final String REP_EXCL_UNASS = "vulas.report.exceptionExcludeUnassessed";
    public static final String REP_EXCL_BUGS = "vulas.report.exceptionExcludeBugs";
    public static final String REP_DIR = "vulas.report.reportDir";
    public static final String REP_OVERRIDE_VER = "vulas.report.overridePomVersion";
    public static final String SEQ_DEFAULT = "vulas.core.sequence.defaultGoals";
    public static final String SIGN_BUGS = "vulas.core.sign.bugs";
    public static final String SIGN_BUGS0 = "vulas.core.sign.saveEditScripts";
    public static final String SIGN_BUGS1 = "vulas.core.sign.saveEditScriptIntersection";
    public static final String SIGN_BUGS2 = "vulas.core.sign.saveDecompiledArchive";
    public static final String SIGN_BUGS3 = "vulas.core.sign.showDecompiledConstruct";
    public static final String SIGN_BUGS4 = "vulas.core.sign.relaxDecompiler";
    public static final String SIGN_BUGS5 = "vulas.core.sign.relaxEditScript";
    public static final String SIGN_BUGS6 = "vulas.core.sign.relaxEqualIgnoreParentRoot";
    public static final String SIGN_BUGS7 = "vulas.core.sign.relaxStripFinals";
    public static final String SIGN_BUGS8 = "vulas.core.sign.relaxRelaxedByDefault";
    public static final String INSTR_SRC_DIR = "vulas.core.instr.sourceDir";
    public static final String INSTR_SEARCH_RECURSIVE = "vulas.core.instr.searchRecursive";
    public static final String INSTR_TARGET_DIR = "vulas.core.instr.targetDir";
    public static final String INSTR_INCLUDE_DIR = "vulas.core.instr.includeDir";
    public static final String INSTR_LIB_DIR = "vulas.core.instr.libDir";
    public static final String INSTR_CHOOSEN_INSTR = "vulas.core.instr.instrumentorsChoosen";
    public static final String INSTR_MAX_STACKTRACES = "vulas.core.instr.maxStacktraces";
    public static final String INSTR_WRITE_CODE = "vulas.core.instr.writeCode";
    public static final String INSTR_FLD_ANNOS = "vulas.core.instr.fieldAnnotations";
    public static final String INSTR_BLACKLIST_DIRS = "vulas.core.instr.blacklist.dirs";
    public static final String INSTR_BLACKLIST_JAR_SCOPES = "vulas.core.instr.blacklist.jars.ignoreScopes";
    public static final String INSTR_BLACKLIST_JARS = "vulas.core.instr.blacklist.jars";
    public static final String INSTR_BLACKLIST_CUSTOM_JARS = "vulas.core.instr.blacklist.jars.custom";
    public static final String INSTR_BLACKLIST_CLASSES = "vulas.core.instr.blacklist.classes";
    public static final String INSTR_BLACKLIST_JRE_CLASSES = "vulas.core.instr.blacklist.classes.jre";
    public static final String INSTR_BLACKLIST_CUSTOM_CLASSES = "vulas.core.instr.blacklist.classes.custom";
    public static final String INSTR_BLACKLIST_CLASSLOADER = "vulas.core.instr.blacklist.classloader";
    public static final String INSTR_BLACKLIST_CLASSLOADER_ACC_CHILD = "vulas.core.instr.whitelist.classloader.acceptChilds";
    public static final String INSTR_SLICE_WHITELIST = "vulas.core.instr.slice.whitelist";
    public static final String INSTR_SLICE_BLACKLIST = "vulas.core.instr.slice.blacklist";
    public static final String INSTR_SLICE_GUARD_OPEN = "vulas.core.instr.slice.guardOpen";
    public static final String MONI_PERIODIC_UPL_ENABLED = "vulas.core.monitor.periodicUpload.enabled";
    public static final String MONI_PERIODIC_UPL_INTERVAL = "vulas.core.monitor.periodicUpload.interval";
    public static final String MONI_PERIODIC_UPL_BATCH_SIZE = "vulas.core.monitor.periodicUpload.batchSize";
    public static final String MONI_PERIODIC_MAX_ITEMS = "vulas.core.monitor.maxItems";
    public static final String MONI_BLACKLIST_JARS = "vulas.core.monitor.blacklist.jars";
    private static Integer cachedMaxItems = null;
    private static String vulasRelease = null;

    public static boolean isBackendOffline(VulasConfiguration _c) {
        return ConnectType.OFFLINE.equals((Object)CoreConfiguration.getBackendConnectType(_c));
    }

    public static boolean isBackendReadOnly(VulasConfiguration _c) {
        return ConnectType.READ_ONLY.equals((Object)CoreConfiguration.getBackendConnectType(_c));
    }

    public static boolean isBackendReadWrite(VulasConfiguration _c) {
        return ConnectType.READ_WRITE.equals((Object)CoreConfiguration.getBackendConnectType(_c));
    }

    private static ConnectType getBackendConnectType(VulasConfiguration _c) {
        String value = _c.getConfiguration().getString(BACKEND_CONNECT, null);
        if ("READ_WRITE".equalsIgnoreCase(value)) {
            return ConnectType.READ_WRITE;
        }
        if ("READ_ONLY".equalsIgnoreCase(value)) {
            return ConnectType.READ_ONLY;
        }
        if ("OFFLINE".equalsIgnoreCase(value)) {
            return ConnectType.OFFLINE;
        }
        throw new IllegalStateException("Illegal value of configuration setting [vulas.core.backendConnection]: [" + value + "]");
    }

    public static boolean isJarUploadEnabled(VulasConfiguration _vc) {
        return _vc.getConfiguration().getBoolean(APP_LIB_UPLOAD, false);
    }

    public static Application getAppContext() throws ConfigurationException {
        return CoreConfiguration.getAppContext(VulasConfiguration.getGlobal());
    }

    public static Application getAppContext(VulasConfiguration _c) throws ConfigurationException {
        Configuration c = _c.getConfiguration();
        Application a = null;
        try {
            a = new Application(c.getString(APP_CTX_GROUP), c.getString(APP_CTX_ARTIF), c.getString(APP_CTX_VERSI));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Application incomplete: " + e.getMessage(), (Throwable)e);
        }
        if (!a.isComplete()) {
            throw new ConfigurationException("Application incomplete: " + a.toString());
        }
        return a;
    }

    public static final GoalContext buildGoalContextFromGlobalConfiguration() {
        return CoreConfiguration.buildGoalContextFromConfiguration(VulasConfiguration.getGlobal());
    }

    public static final GoalContext buildGoalContextFromConfiguration(VulasConfiguration _c) {
        Configuration c = _c.getConfiguration();
        GoalContext ctx = new GoalContext();
        ctx.setVulasConfiguration(_c);
        Tenant tenant = null;
        if (!_c.isEmpty(TENANT_TOKEN)) {
            tenant = new Tenant(c.getString(TENANT_TOKEN));
            ctx.setTenant(tenant);
        } else {
            log.warn((Object)"No tenant configured, hence, the backend's default tenant is used");
        }
        if (!_c.isEmpty(SPACE_TOKEN)) {
            Space space = new Space();
            space.setSpaceToken(c.getString(SPACE_TOKEN));
            ctx.setSpace(space);
        } else {
            log.warn((Object)("No space configured, hence, the default space of " + (tenant == null ? "the default tenant" : "tenant [" + tenant + "]") + " is used"));
        }
        Application a = new Application(c.getString(APP_CTX_GROUP), c.getString(APP_CTX_ARTIF), c.getString(APP_CTX_VERSI));
        if (a.isComplete()) {
            ctx.setApplication(a);
        } else {
            log.warn((Object)("Incomplete application context: " + a.toString()));
        }
        return ctx;
    }

    public static final boolean existsInBackend(Application _app) {
        boolean exists = false;
        try {
            exists = BackendConnector.getInstance().isAppExisting(CoreConfiguration.buildGoalContextFromGlobalConfiguration(), _app);
        }
        catch (BackendConnectionException e) {
            log.error((Object)("Error while checking whether " + _app + " exists in backend: " + e.getMessage()));
        }
        return exists;
    }

    public static synchronized boolean isMaxItemsCollected(int _count_collected_items) {
        if (cachedMaxItems == null) {
            cachedMaxItems = VulasConfiguration.getGlobal().getConfiguration().getInt(MONI_PERIODIC_MAX_ITEMS, -1);
        }
        return cachedMaxItems != -1 && _count_collected_items >= cachedMaxItems;
    }

    public static synchronized String getVulasRelease() {
        if (vulasRelease == null && ((vulasRelease = CoreConfiguration.class.getPackage().getImplementationVersion()) == null || vulasRelease.equals(""))) {
            log.warn((Object)"Cannot determine Vulas version from manifest entry [Implementation-Version], check Vulas JAR");
            vulasRelease = "unknown";
        }
        return vulasRelease;
    }

    public static SignatureFactory getSignatureFactory(ConstructId _id) {
        ServiceLoader<SignatureFactory> loader = ServiceLoader.load(SignatureFactory.class);
        SignatureFactory factory = null;
        for (SignatureFactory la : loader) {
            if (!la.isSupportedConstructId(_id)) continue;
            factory = la;
        }
        return factory;
    }

    public static enum ConnectType {
        OFFLINE,
        READ_ONLY,
        READ_WRITE;

    }
}

