/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.AbstractGoal;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.Dependency;
import com.sap.psr.vulas.shared.util.FileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAppGoal
extends AbstractGoal {
    private static final Log log = LogFactory.getLog(AbstractAppGoal.class);
    private Map<Path, Dependency> knownDependencies = new HashMap<Path, Dependency>();
    private List<Path> searchPaths = new ArrayList<Path>();

    protected AbstractAppGoal(GoalType _type) {
        super(_type);
    }

    protected Application getApplicationContext() {
        return this.getGoalContext().getApplication();
    }

    public Map<Path, Dependency> getKnownDependencies() {
        return this.knownDependencies;
    }

    public void setKnownDependencies(Map<Path, Dependency> _paths) {
        this.knownDependencies = _paths;
    }

    @Override
    protected void prepareExecution() throws GoalConfigurationException {
        super.prepareExecution();
        if (this.getApplicationContext() == null) {
            throw new GoalConfigurationException("Application context is required to execute goal [" + this.getGoalType().toString() + "]");
        }
        try {
            boolean created;
            this.addAppPaths(FileUtil.getPaths((String[])this.getConfiguration().getStringArray("vulas.core.app.sourceDir", null)));
            if (!this.hasAppPaths()) {
                log.warn((Object)"No search path(s) provided");
            }
            if (this.getGoalContext().hasSpace()) {
                try {
                    boolean space_exists = BackendConnector.getInstance().isSpaceExisting(this.getGoalContext(), this.getGoalContext().getSpace());
                    if (!space_exists) {
                        throw new GoalConfigurationException("Workspace [" + this.getGoalContext().getSpace() + "] cannot be verified: Not present in server");
                    }
                }
                catch (BackendConnectionException e) {
                    throw new GoalConfigurationException("Workspace [" + this.getGoalContext().getSpace() + "] cannot be verified:" + e.getMessage());
                }
            }
            if (!(created = this.upload(true))) {
                throw new GoalConfigurationException("Upload of goal execution failed, aborting the goal execution...");
            }
        }
        catch (IllegalArgumentException e) {
            throw new GoalConfigurationException(e.getMessage());
        }
    }

    public List<Path> getAppPaths() {
        return this.searchPaths;
    }

    public void addAppPath(Path _p) throws IllegalArgumentException {
        if (!FileUtil.isAccessibleDirectory((Path)_p) && !FileUtil.isAccessibleFile((Path)_p)) {
            log.warn((Object)("[" + _p + "] is not an accessible file or directory"));
        } else if (this.getAppPaths().contains(_p)) {
            log.debug((Object)("[" + _p + "] is already part of application paths, and will not be added another time"));
        } else {
            this.searchPaths.add(_p);
        }
    }

    public void addAppPaths(Set<Path> _paths) throws IllegalArgumentException {
        for (Path p : _paths) {
            this.addAppPath(p);
        }
    }

    public boolean hasAppPaths() {
        return this.getAppPaths() != null && !this.getAppPaths().isEmpty();
    }
}

