/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.goals.ExecutionObserver;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.goals.GoalExecutionException;
import com.sap.psr.vulas.shared.enums.GoalClient;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.JsonBuilder;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.Space;
import com.sap.psr.vulas.shared.json.model.Tenant;
import com.sap.psr.vulas.shared.util.MemoryMonitor;
import com.sap.psr.vulas.shared.util.StopWatch;
import com.sap.psr.vulas.shared.util.StringList;
import com.sap.psr.vulas.shared.util.StringUtil;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractGoal
implements Runnable {
    private static final Log log = LogFactory.getLog(AbstractGoal.class);
    protected static final String[] CLASS_EXT = new String[]{"CLASS"};
    protected static final String[] JAR_EXT = new String[]{"jar"};
    protected static final String[] WAR_EXT = new String[]{"war"};
    protected static final String[] JAR_WAR_EXT = new String[]{"jar", "war"};
    private GoalClient client = null;
    private String id = null;
    private final long createdAt = System.currentTimeMillis();
    private VulasConfiguration configuration;
    private GoalContext goalContext = null;
    private GoalType goalType = null;
    private Exception exception = null;
    private StopWatch stopWatch = null;
    private MemoryMonitor memoThread = null;
    private Map<String, String> systemInfo = new HashMap<String, String>();
    private Map<String, Double> goalStats = new HashMap<String, Double>();
    private ExecutionObserver observer = null;
    private boolean goalUploadEnabled = true;

    protected AbstractGoal(GoalType _goal) {
        this(_goal, true);
    }

    protected AbstractGoal(GoalType _goal, boolean _monitor_mem) {
        this.goalType = _goal;
        if (_monitor_mem) {
            this.memoThread = new MemoryMonitor();
        }
        this.systemInfo.put("runtime.availableProcessors", Integer.toString(Runtime.getRuntime().availableProcessors()));
    }

    public synchronized String getId() {
        if (this.id == null) {
            this.id = this.client != null ? this.client + "-" + this.goalType + "-" + this.createdAt + "-" + (int)Math.abs(Math.random() * 1.0E8) : this.goalType + "-" + this.createdAt + "-" + (int)Math.abs(Math.random() * 1.0E8);
        }
        return this.id;
    }

    public void setObserver(ExecutionObserver observer) {
        this.observer = observer;
    }

    public GoalType getGoalType() {
        return this.goalType;
    }

    public GoalClient getGoalClient() {
        return this.client;
    }

    public void setGoalClient(GoalClient _client) {
        this.client = _client;
    }

    public boolean runsIn(GoalClient _client) {
        return this.client != null && _client != null && _client.equals((Object)this.client);
    }

    public final void executeAsync() {
        Thread t = new Thread((Runnable)this, "vulas-" + this.goalType.toString().toLowerCase());
        t.start();
    }

    @Override
    public final void run() {
        try {
            this.execute();
        }
        catch (GoalConfigurationException e) {
            log.error((Object)("Error while configuring " + this + ": " + e.getMessage()), (Throwable)e);
        }
        catch (GoalExecutionException e) {
            log.error((Object)("Error while executing " + this + ": " + e.getMessage()), (Throwable)e);
        }
    }

    public final void executeSync() throws GoalConfigurationException, GoalExecutionException {
        this.execute();
    }

    private final void execute() throws GoalConfigurationException, GoalExecutionException {
        try {
            this.start();
            this.executeTasks();
            this.stop();
        }
        catch (GoalConfigurationException gce) {
            this.stop(gce);
            this.skipGoalUpload();
            throw gce;
        }
        catch (GoalExecutionException gee) {
            this.stop(gee);
            throw gee;
        }
        catch (Exception e) {
            this.stop(e);
            throw new GoalExecutionException(e);
        }
        finally {
            if (this.goalUploadEnabled) {
                this.upload(false);
            }
        }
    }

    protected final synchronized VulasConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new VulasConfiguration();
        }
        return this.configuration;
    }

    public final AbstractGoal setConfiguration(VulasConfiguration _c) {
        this.configuration = _c;
        return this;
    }

    public final synchronized GoalContext getGoalContext() {
        if (this.goalContext == null) {
            Configuration c = this.getConfiguration().getConfiguration();
            this.goalContext = new GoalContext();
            this.goalContext.setVulasConfiguration(this.getConfiguration());
            if (!this.getConfiguration().isEmpty("vulas.core.tenant.token")) {
                this.goalContext.setTenant(new Tenant(c.getString("vulas.core.tenant.token")));
            }
            if (!this.getConfiguration().isEmpty("vulas.core.space.token")) {
                Space space = new Space();
                space.setSpaceToken(c.getString("vulas.core.space.token"));
                this.goalContext.setSpace(space);
            }
            if (Application.canBuildApplication((String)c.getString("vulas.core.appContext.group"), (String)c.getString("vulas.core.appContext.artifact"), (String)c.getString("vulas.core.appContext.version"))) {
                Application a = new Application(c.getString("vulas.core.appContext.group"), c.getString("vulas.core.appContext.artifact"), c.getString("vulas.core.appContext.version"));
                if (a.isComplete()) {
                    this.goalContext.setApplication(a);
                } else {
                    log.warn((Object)("Incomplete application context: " + a.toString()));
                }
            }
        }
        return this.goalContext;
    }

    public final void setGoalContext(GoalContext _ctx) {
        this.goalContext = _ctx;
    }

    protected void prepareExecution() throws GoalConfigurationException {
        BackendConnector.getInstance().cleanCache();
        try {
            this.getConfiguration().checkSettings();
        }
        catch (ConfigurationException e) {
            throw new GoalConfigurationException(e);
        }
    }

    protected void checkPreconditions() throws GoalConfigurationException {
    }

    protected abstract void executeTasks() throws Exception;

    protected void cleanAfterExecution() {
    }

    protected Object getResultObject() {
        return null;
    }

    public void start() throws GoalConfigurationException {
        this.stopWatch = new StopWatch(this.toString()).start();
        if (this.memoThread != null) {
            Thread t = new Thread((Runnable)this.memoThread, "vulas-memo");
            t.setPriority(1);
            t.start();
        }
        this.prepareExecution();
        this.checkPreconditions();
        this.stopWatch.lap("Completed goal preparation", false);
    }

    public void stop() {
        if (!this.stopWatch.isRunning()) {
            throw new IllegalStateException("Goal execution already finished");
        }
        this.stopMemo();
        this.stopWatch.lap("Completed execution", true);
        this.cleanAfterExecution();
        this.stopWatch.lap("Completed clean-up", false);
        this.stopWatch.stop();
        this.notifyObserver();
    }

    public void stop(Exception _e) {
        if (!this.stopWatch.isRunning()) {
            throw new IllegalStateException("Goal execution already finished");
        }
        this.stopMemo();
        this.exception = _e;
        this.stopWatch.stop(_e);
        this.notifyObserver();
    }

    private void notifyObserver() {
        if (this.observer != null) {
            this.observer.callback(this);
        }
    }

    private final void stopMemo() {
        if (this.memoThread != null) {
            this.memoThread.stop();
        }
    }

    public void addGoalStats(String _prefix, Map<String, Long> _stats) {
        for (Map.Entry<String, Long> entry : _stats.entrySet()) {
            this.addGoalStats(_prefix == null || _prefix.equals("") ? entry.getKey() : _prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    public void addGoalStats(String _key, long _val) {
        this.addGoalStats(_key, (double)_val);
    }

    public void addGoalStats(String _key, int _val) {
        this.addGoalStats(_key, (double)_val);
    }

    public void addGoalStats(String _key, double _val) {
        this.goalStats.put(_key, new Double(_val));
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Goal [id=").append(this.getId()).append(", type=").append(this.getGoalType());
        if (this.goalContext != null) {
            b.append(", ctx=").append(this.goalContext.toString());
        }
        b.append("]");
        return b.toString();
    }

    public String toJson() throws IllegalStateException {
        StringBuilder b = new StringBuilder();
        b.append("{\"executionId\":\"").append(this.getId()).append("\"");
        b.append(",\"goal\":\"").append(this.goalType).append("\"");
        b.append(",\"startedAtClient\":\"").append(StringUtil.formatDate((long)this.stopWatch.getStartMillis())).append("\"");
        b.append(",\"clientVersion\":").append(JsonBuilder.escape((String)CoreConfiguration.getVulasRelease()));
        if (this.exception != null && this.exception.getMessage() != null) {
            b.append(",\"exception\":").append(JsonBuilder.escape((String)this.exception.getMessage().substring(0, Math.min(this.exception.getMessage().length(), 255))));
        }
        if (this.stopWatch.isRunning()) {
            b.append(",\"runtimeNano\":-1");
        } else {
            b.append(",\"runtimeNano\":").append(this.stopWatch.getRuntime());
        }
        if (this.memoThread != null) {
            b.append(",\"memMax\":").append(this.memoThread.getJvmMax());
            b.append(",\"memUsedMax\":").append(this.memoThread.getMaxUsed());
            b.append(",\"memUsedAvg\":").append(this.memoThread.getAvgUsed());
        }
        b.append(",\"configuration\":[");
        int c = 0;
        Iterator iter = this.getConfiguration().getConfiguration().subset("vulas").getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String[] stringArray = this.getConfiguration().getConfiguration().getStringArray("vulas." + (String)key);
            if (c++ > 0) {
                b.append(",");
            }
            b.append("{\"source\":\"GOAL_CONFIG\",\"name\":").append(JsonBuilder.escape((String)key)).append(",\"value\":").append(JsonBuilder.escape((String)StringUtil.join((String[])stringArray, (String)","))).append("}");
        }
        b.append("]");
        b.append(",\"statistics\":{");
        c = 0;
        for (Map.Entry entry : this.goalStats.entrySet()) {
            if (c++ > 0) {
                b.append(",");
            }
            b.append(JsonBuilder.escape((String)((String)entry.getKey()))).append(":").append(entry.getValue());
        }
        b.append("}");
        StringList env_whitelist = this.getConfiguration().getStringList(new String[]{"vulas.shared.env", "vulas.shared.env.custom"});
        StringList stringList = this.getConfiguration().getStringList(new String[]{"vulas.shared.sys", "vulas.shared.sys.custom"});
        this.systemInfo.putAll(env_whitelist.filter(System.getenv(), true, StringList.ComparisonMode.EQUALS, StringList.CaseSensitivity.CASE_INSENSITIVE));
        for (Object object : System.getProperties().keySet()) {
            String key_string = (String)object;
            if (!stringList.contains(key_string, StringList.ComparisonMode.STARTSWITH, StringList.CaseSensitivity.CASE_INSENSITIVE)) continue;
            this.systemInfo.put(key_string, System.getProperty(key_string));
        }
        b.append(",\"systemInfo\":[");
        c = 0;
        for (Map.Entry entry : this.systemInfo.entrySet()) {
            if (c++ > 0) {
                b.append(",");
            }
            b.append("{\"source\":\"SYSTEM_INFO\",\"name\":").append(JsonBuilder.escape((String)((String)entry.getKey()))).append(",\"value\":").append(JsonBuilder.escape((String)((String)entry.getValue()))).append("}");
        }
        b.append("]}");
        return b.toString();
    }

    protected final void skipGoalUpload() {
        this.goalUploadEnabled = false;
    }

    public boolean upload(boolean _before) {
        boolean ret = false;
        try {
            log.info((Object)"Uploading goal execution info ...");
            ret = BackendConnector.getInstance().uploadGoalExecution(this.getGoalContext(), this, _before);
            log.info((Object)"Uploaded goal execution info");
        }
        catch (Exception e) {
            log.error((Object)("Error while uploading goal execution info: " + e.getMessage()));
        }
        return ret;
    }
}

