/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.goals.AbstractGoal;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.shared.enums.ExportConfiguration;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Space;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSpaceGoal
extends AbstractGoal {
    private static final Log log = LogFactory.getLog(AbstractSpaceGoal.class);

    protected AbstractSpaceGoal(GoalType _type) {
        super(_type);
    }

    @Override
    protected void checkPreconditions() throws GoalConfigurationException {
        if (!this.getGoalContext().hasTenant()) {
            throw new GoalConfigurationException("No tenant configured");
        }
    }

    protected void updateFromConfig(Space _s) {
        Configuration c = this.getConfiguration().getConfiguration();
        _s.setSpaceName(c.getString("vulas.core.space.name", null));
        _s.setSpaceDescription(c.getString("vulas.core.space.description", null));
        _s.setExportConfiguration(ExportConfiguration.parse((String)c.getString("vulas.core.space.exportConfiguration", "AGGREGATED")));
        _s.setPublic(c.getBoolean("vulas.core.space.public", true));
        _s.setBugFilter(c.getInt("vulas.core.space.bugFilter", -1));
        _s.setOwnerEmails(new HashSet<String>(Arrays.asList(c.getStringArray("vulas.core.space.bugFilter"))));
    }
}

