/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.core.util.CoreConfiguration;
import com.sap.psr.vulas.goals.AbstractAppGoal;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.malice.MaliciousnessAnalysisResult;
import com.sap.psr.vulas.malice.MaliciousnessAnalyzerLoop;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.Dependency;
import com.sap.psr.vulas.shared.json.model.Library;
import com.sap.psr.vulas.tasks.BomTask;
import java.nio.file.Paths;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BomGoal
extends AbstractAppGoal {
    private static final Log log = LogFactory.getLog(BomGoal.class);

    public BomGoal() {
        super(GoalType.APP);
    }

    @Override
    protected void prepareExecution() throws GoalConfigurationException {
        super.prepareExecution();
    }

    @Override
    protected void executeTasks() throws Exception {
        Application a = this.getApplicationContext();
        ServiceLoader<BomTask> loader = ServiceLoader.load(BomTask.class);
        for (BomTask bomTask : loader) {
            try {
                bomTask.setApplication(a);
                bomTask.setSearchPaths(this.getAppPaths());
                bomTask.setGoalClient(this.getGoalClient());
                bomTask.setKnownDependencies(this.getKnownDependencies());
                bomTask.configure(this.getConfiguration());
                bomTask.execute();
                bomTask.cleanUp();
                a = bomTask.getCompletedApplication();
            }
            catch (Exception e) {
                log.error((Object)("Error running task " + bomTask + ": " + e.getMessage()), (Throwable)e);
            }
        }
        MaliciousnessAnalyzerLoop loop = new MaliciousnessAnalyzerLoop();
        if (a.getDependencies() != null) {
            for (Dependency dep : a.getDependencies()) {
                Library lib;
                if (dep.getPath() != null && Paths.get(dep.getPath(), new String[0]).toFile().canRead()) {
                    Set<MaliciousnessAnalysisResult> set = loop.isMalicious(Paths.get(dep.getPath(), new String[0]).toFile());
                }
                if ((lib = dep.getLib()) != null) {
                    if (lib.hasValidDigest()) {
                        BackendConnector.getInstance().uploadLibrary(this.getGoalContext(), lib);
                        if (!CoreConfiguration.isJarUploadEnabled(this.getGoalContext().getVulasConfiguration())) continue;
                        BackendConnector.getInstance().uploadLibraryFile(lib.getDigest(), Paths.get(dep.getPath(), new String[0]));
                        continue;
                    }
                    log.error((Object)("Library of dependency [" + dep + "] has no valid digest"));
                    continue;
                }
                log.error((Object)("Dependency [" + dep + "] has no library"));
            }
        }
        boolean bl = this.getConfiguration().getConfiguration().getBoolean("vulas.core.app.uploadEmpty", false);
        boolean app_exists_in_backend = BackendConnector.getInstance().isAppExisting(this.getGoalContext(), a);
        if (!a.isEmpty().booleanValue() || app_exists_in_backend || bl) {
            log.info((Object)("Save app " + a + " with [" + a.getDependencies().size() + "] dependencies and [" + a.getConstructs().size() + "] constructs (uploadEmpty=" + bl + ")"));
            BackendConnector.getInstance().uploadApp(this.getGoalContext(), a);
        } else {
            log.warn((Object)("Skip save of empty app " + this.getApplicationContext() + " (uploadEmpty=" + bl + ", existsInBackend=" + app_exists_in_backend + ")"));
            this.skipGoalUpload();
        }
    }
}

