/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.AbstractAppGoal;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CleanGoal
extends AbstractAppGoal {
    private static final Log log = LogFactory.getLog(CleanGoal.class);

    public CleanGoal() {
        super(GoalType.CLEAN);
    }

    @Override
    protected void executeTasks() throws Exception {
        BackendConnector bc = BackendConnector.getInstance();
        Application app = this.getApplicationContext();
        int keepLast = this.getConfiguration().getConfiguration().getInt("vulas.core.clean.purgeVersions.keepLast", 3);
        if (bc.isAppExisting(this.getGoalContext(), app)) {
            bc.cleanApp(this.getGoalContext(), app, this.getConfiguration().getConfiguration().getBoolean("vulas.core.clean.goalHistory", false));
        } else {
            log.info((Object)("App [" + app + "] does not exist in backend, thus, cleaning not possible"));
            this.skipGoalUpload();
            if (keepLast > 0) {
                --keepLast;
            }
        }
        if (this.getConfiguration().getConfiguration().getBoolean("vulas.core.clean.purgeVersions", false)) {
            bc.purgeAppVersions(this.getGoalContext(), app, keepLast);
        }
    }
}

