/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.goals.AbstractGoal;
import com.sap.psr.vulas.goals.BomGoal;
import com.sap.psr.vulas.goals.CleanGoal;
import com.sap.psr.vulas.goals.ReportGoal;
import com.sap.psr.vulas.goals.SequenceGoal;
import com.sap.psr.vulas.goals.SpaceCleanGoal;
import com.sap.psr.vulas.goals.SpaceDelGoal;
import com.sap.psr.vulas.goals.SpaceModGoal;
import com.sap.psr.vulas.goals.SpaceNewGoal;
import com.sap.psr.vulas.goals.UploadGoal;
import com.sap.psr.vulas.shared.enums.GoalClient;
import com.sap.psr.vulas.shared.enums.GoalType;
import javax.validation.constraints.NotNull;

public class GoalFactory {
    public static AbstractGoal create(@NotNull GoalType _type) throws IllegalStateException, IllegalArgumentException {
        AbstractGoal goal = null;
        if (_type.equals((Object)GoalType.CLEAN)) {
            goal = new CleanGoal();
        } else if (_type.equals((Object)GoalType.APP)) {
            goal = new BomGoal();
        } else if (_type.equals((Object)GoalType.A2C)) {
            String clazzname = "com.sap.psr.vulas.cg.A2CGoal";
            try {
                Class<?> clazz = Class.forName("com.sap.psr.vulas.cg.A2CGoal");
                goal = (AbstractGoal)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.A2CGoal]: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.A2CGoal]: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.A2CGoal]: " + e.getMessage());
            }
        } else if (_type.equals((Object)GoalType.T2C)) {
            String clazzname = "com.sap.psr.vulas.cg.T2CGoal";
            try {
                Class<?> clazz = Class.forName("com.sap.psr.vulas.cg.T2CGoal");
                goal = (AbstractGoal)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.T2CGoal]: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.T2CGoal]: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.cg.T2CGoal]: " + e.getMessage());
            }
        } else if (_type.equals((Object)GoalType.INSTR)) {
            String clazzname = "com.sap.psr.vulas.java.goals.InstrGoal";
            try {
                Class<?> clazz = Class.forName("com.sap.psr.vulas.java.goals.InstrGoal");
                goal = (AbstractGoal)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.java.goals.InstrGoal]: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.java.goals.InstrGoal]: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot create instance of class [com.sap.psr.vulas.java.goals.InstrGoal]: " + e.getMessage());
            }
        } else if (_type.equals((Object)GoalType.REPORT)) {
            goal = new ReportGoal();
        } else if (_type.equals((Object)GoalType.UPLOAD)) {
            goal = new UploadGoal();
        } else if (_type.equals((Object)GoalType.SEQUENCE)) {
            goal = new SequenceGoal();
        } else if (_type.equals((Object)GoalType.SPACENEW)) {
            goal = new SpaceNewGoal();
        } else if (_type.equals((Object)GoalType.SPACEMOD)) {
            goal = new SpaceModGoal();
        } else if (_type.equals((Object)GoalType.SPACECLEAN)) {
            goal = new SpaceCleanGoal();
        } else if (_type.equals((Object)GoalType.SPACEDEL)) {
            goal = new SpaceDelGoal();
        } else {
            throw new IllegalArgumentException("Goal [" + _type + "] is not supported");
        }
        return goal;
    }

    public static AbstractGoal create(@NotNull GoalType _type, @NotNull GoalClient _client) throws IllegalStateException, IllegalArgumentException {
        AbstractGoal goal = GoalFactory.create(_type);
        goal.setGoalClient(_client);
        return goal;
    }
}

