/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.goals.AbstractAppGoal;
import com.sap.psr.vulas.goals.GoalExecutionException;
import com.sap.psr.vulas.goals.ReportException;
import com.sap.psr.vulas.report.Report;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.util.FileUtil;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class ReportGoal
extends AbstractAppGoal {
    private Set<Application> modules = null;

    public ReportGoal() {
        super(GoalType.REPORT);
    }

    public void setApplicationModules(Set<Application> _modules) {
        this.modules = _modules;
    }

    public void setReportDir(Path _path) throws IllegalArgumentException {
        if (!FileUtil.isAccessibleDirectory((Path)_path)) {
            throw new IllegalArgumentException("Cannot write report to [" + _path + "]");
        }
    }

    @Override
    protected void executeTasks() throws Exception {
        Configuration cfg = this.getConfiguration().getConfiguration();
        Report report = new Report(this.getGoalContext(), this.getApplicationContext(), this.modules);
        report.setExceptionThreshold(cfg.getString("vulas.report.exceptionThreshold", "actuallyExecutes"));
        report.addExcludedBugs(cfg.getStringArray("vulas.report.exceptionExcludeBugs"));
        report.addExcludedScopes(cfg.getStringArray("vulas.report.exceptionScopeBlacklist"));
        report.setIgnoreUnassessed(cfg.getString("vulas.report.exceptionExcludeUnassessed", "known"));
        try {
            report.fetchAppVulnerabilities();
        }
        catch (Exception e) {
            throw new GoalExecutionException("Error fetching vulnerabilities: " + e.getMessage(), e);
        }
        report.processVulnerabilities();
        report.writeResult(this.getConfiguration().getDir("vulas.report.reportDir"));
        this.addGoalStats("report", report.getStats());
        if (report.isThrowBuildException()) {
            ReportException re = new ReportException(report.getExceptionMessage(), null);
            re.setLongMessage(report.getResultAsString());
            throw re;
        }
    }
}

