/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.goals.AbstractAppGoal;
import com.sap.psr.vulas.goals.AbstractGoal;
import com.sap.psr.vulas.goals.GoalConfigurationException;
import com.sap.psr.vulas.goals.GoalFactory;
import com.sap.psr.vulas.shared.enums.GoalType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceGoal
extends AbstractAppGoal {
    private static final Log log = LogFactory.getLog(SequenceGoal.class);
    private List<AbstractGoal> sequence = new ArrayList<AbstractGoal>();
    private double progress = 0.0;

    public SequenceGoal() {
        super(GoalType.SEQUENCE);
    }

    public void addGoal(AbstractGoal _goal) {
        this.sequence.add(_goal);
    }

    @Override
    protected void prepareExecution() throws GoalConfigurationException {
        super.prepareExecution();
        if (this.sequence.isEmpty()) {
            String[] goals = this.getConfiguration().getStringArray("vulas.core.sequence.defaultGoals", null);
            if (goals == null || goals.length == 0) {
                throw new GoalConfigurationException("No goals have been added to the sequence");
            }
            for (String g : goals) {
                try {
                    GoalType gt = GoalType.parseGoal((String)g);
                    this.addGoal(GoalFactory.create(gt, this.getGoalClient()));
                }
                catch (IllegalArgumentException e) {
                    throw new GoalConfigurationException("Cannot add goal [" + g + "] to sequence: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    throw new GoalConfigurationException("Cannot add goal [" + g + "] to sequence: " + e.getMessage());
                }
            }
        }
        for (AbstractGoal g : this.sequence) {
            g.getGoalContext().setApplication(this.getApplicationContext());
            ((AbstractAppGoal)g).addAppPaths(new HashSet<Path>(this.getAppPaths()));
        }
    }

    @Override
    protected void executeTasks() throws Exception {
        int i = 0;
        for (AbstractGoal g : this.sequence) {
            g.executeSync();
            this.progress = (double)(++i) / (double)this.sequence.size();
        }
    }

    public double getProgress() {
        return this.progress;
    }
}

