/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.AbstractSpaceGoal;
import com.sap.psr.vulas.goals.GoalExecutionException;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Space;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpaceModGoal
extends AbstractSpaceGoal {
    private static final Log log = LogFactory.getLog(SpaceModGoal.class);

    public SpaceModGoal() {
        super(GoalType.SPACEMOD);
    }

    @Override
    protected void executeTasks() throws Exception {
        Space s = this.getGoalContext().getSpace();
        this.updateFromConfig(s);
        BackendConnector bc = BackendConnector.getInstance();
        if (!s.hasNameAndDescription()) {
            throw new GoalExecutionException("Space modification requires a name and description, adjust the configuration accordingly", null);
        }
        if (!bc.isSpaceExisting(this.getGoalContext(), s)) {
            throw new GoalExecutionException("Space with token [" + s.getSpaceToken() + "] does not exist", null);
        }
        bc.modifySpace(this.getGoalContext(), s);
    }
}

