/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.goals;

import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.AbstractSpaceGoal;
import com.sap.psr.vulas.goals.GoalExecutionException;
import com.sap.psr.vulas.shared.enums.GoalType;
import com.sap.psr.vulas.shared.json.model.Space;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpaceNewGoal
extends AbstractSpaceGoal {
    private static final Log log = LogFactory.getLog(SpaceNewGoal.class);
    private Space createdSpace = null;

    public SpaceNewGoal() {
        super(GoalType.SPACENEW);
    }

    @Override
    protected void executeTasks() throws Exception {
        Space s = new Space();
        this.updateFromConfig(s);
        if (s.isValidSpaceToken()) {
            log.warn((Object)("Upon space creation a new token will be generated, the current token [" + s.getSpaceToken() + "] will be ignored"));
        }
        if (!s.hasNameAndDescription()) {
            this.skipGoalUpload();
            throw new GoalExecutionException("Space creation requires name and description, adjust the configuration accordingly", null);
        }
        this.createdSpace = BackendConnector.getInstance().createSpace(this.getGoalContext(), s);
        if (this.createdSpace == null) {
            log.error((Object)"Space creation failed");
        } else {
            log.info((Object)("Space creation succeeded: Use space token [" + this.createdSpace.spaceToken + "] for configuration setting [" + "vulas.core.space.token" + "]"));
            this.getGoalContext().setSpace(this.createdSpace);
        }
    }

    @Override
    protected Object getResultObject() {
        return this.createdSpace;
    }
}

