/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.malice;

import com.sap.psr.vulas.malice.MaliciousnessAnalysisResult;
import com.sap.psr.vulas.malice.MaliciousnessAnalyzer;
import com.sap.psr.vulas.shared.util.DirUtil;
import com.sap.psr.vulas.shared.util.StringUtil;
import com.sap.psr.vulas.shared.util.VulasConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipSlipAnalyzer
implements MaliciousnessAnalyzer {
    private static final Log log = LogFactory.getLog(ZipSlipAnalyzer.class);
    private Path destinationPath = VulasConfiguration.getGlobal().getTmpDir().toAbsolutePath().resolve(StringUtil.getRandonString((int)10));

    @Override
    public MaliciousnessAnalysisResult isMalicious(File _file) {
        MaliciousnessAnalysisResult mal = null;
        String name = _file.getName();
        try (FileInputStream fis = new FileInputStream(_file);){
            if (name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".aar")) {
                mal = this.isMalicious(new ZipInputStream(fis), false);
            } else if (name.endsWith(".tar")) {
                mal = this.isMalicious((InputStream)new TarArchiveInputStream((InputStream)fis), false);
            } else if (name.endsWith(".tar.gz")) {
                mal = this.isMalicious((InputStream)new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(fis))), false);
            } else {
                log.warn((Object)("Cannot analyze [" + _file.toPath().toAbsolutePath() + "]"));
            }
            if (mal != null) {
                mal.setReason("[" + _file.toPath().toAbsolutePath() + "] " + mal.getReason());
                if (mal.isMalicious()) {
                    log.warn((Object)mal.getReason());
                } else {
                    log.info((Object)mal.getReason());
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("File [" + _file.getAbsolutePath() + "] cannot be found"));
        }
        catch (IOException ioe) {
            log.error((Object)(ioe.getClass().getSimpleName() + " when opening [" + _file.getAbsolutePath() + "]: " + ioe.getMessage()), (Throwable)ioe);
        }
        return mal;
    }

    @Override
    public MaliciousnessAnalysisResult isMalicious(InputStream _is, boolean _log) {
        MaliciousnessAnalysisResult mal;
        int count;
        StringBuffer buffer;
        block16: {
            buffer = new StringBuffer();
            count = 0;
            mal = new MaliciousnessAnalysisResult();
            mal.setAnalyzer(this.getClass().getName());
            if (_is instanceof ZipInputStream) {
                while (true) {
                    try {
                        ZipEntry e;
                        while ((e = ((ZipInputStream)_is).getNextEntry()) != null) {
                            ++count;
                            boolean is_below = DirUtil.isBelowDestinationPath((Path)this.destinationPath, (String)e.getName());
                            if (is_below) continue;
                            mal.setResult(1.0);
                            if (buffer.length() > 0) {
                                buffer.append(", ");
                            }
                            buffer.append(e.getName());
                        }
                        break block16;
                    }
                    catch (IOException ioe) {
                        log.error((Object)(ioe.getClass().getSimpleName() + " when looping archive entries: " + ioe.getMessage()), (Throwable)ioe);
                        continue;
                    }
                    break;
                }
            }
            if (_is instanceof ArchiveInputStream) {
                while (true) {
                    try {
                        ArchiveEntry e;
                        while ((e = ((ArchiveInputStream)_is).getNextEntry()) != null) {
                            ++count;
                            boolean is_below = DirUtil.isBelowDestinationPath((Path)this.destinationPath, (String)e.getName());
                            if (is_below) continue;
                            mal.setResult(1.0);
                            if (buffer.length() > 0) {
                                buffer.append(", ");
                            }
                            buffer.append(e.getName());
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)(ioe.getClass().getSimpleName() + " when looping archive entries: " + ioe.getMessage()), (Throwable)ioe);
                        continue;
                    }
                    break;
                }
            }
        }
        if (mal.isMalicious()) {
            mal.setReason("Archive is subject to ZipSlip vulnerability, the following file(s) would be extracted outside of an intended target folder:");
            mal.appendReason(buffer.toString(), " ");
            if (_log) {
                log.warn((Object)mal.getReason());
            }
        } else {
            mal.setReason("Archive is NOT subject to ZipSlip vulnerability, all [" + count + "] archive entries would be extracted inside or below an intended target folder");
            if (_log) {
                log.debug((Object)mal.getReason());
            }
        }
        return mal;
    }
}

