/*
 * Decompiled with CFR 0.152.
 */
package com.sap.psr.vulas.report;

import com.sap.psr.vulas.backend.BackendConnectionException;
import com.sap.psr.vulas.backend.BackendConnector;
import com.sap.psr.vulas.goals.GoalContext;
import com.sap.psr.vulas.shared.connectivity.Service;
import com.sap.psr.vulas.shared.json.model.Application;
import com.sap.psr.vulas.shared.json.model.Bug;
import com.sap.psr.vulas.shared.json.model.LibraryId;
import com.sap.psr.vulas.shared.json.model.VulnerableDependency;
import com.sap.psr.vulas.shared.util.FileUtil;
import com.sap.psr.vulas.shared.util.StringList;
import com.sap.psr.vulas.shared.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class Report {
    private static final Log log = LogFactory.getLog(Report.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyy HH:mm:ss");
    public static final String IGN_UNASS_ALL = "all";
    public static final String IGN_UNASS_KNOWN = "known";
    public static final String IGN_UNASS_OFF = "off";
    private String ignoreUnassessed = "known";
    public static final String THRESHOLD_NONE = "noException";
    public static final String THRESHOLD_DEP_ON = "dependsOn";
    public static final String THRESHOLD_POT_EXE = "potentiallyExecutes";
    public static final String THRESHOLD_ACT_EXE = "actuallyExecutes";
    private static final String TEMPLATE_FILE_HTML = "velocity_template.html";
    static final String REPORT_FILE_HTML = "vulas-report.html";
    private static final String TEMPLATE_FILE_XML = "velocity_template.xml";
    static final String REPORT_FILE_XML = "vulas-report.xml";
    private static final String TEMPLATE_FILE_JSON = "velocity_template.json";
    static final String REPORT_FILE_JSON = "vulas-report.json";
    private Map<String, Long> stats = new HashMap<String, Long>();
    private String exceptionThreshold = "potentiallyExecutes";
    private StringList excludedScopes = new StringList();
    private StringList excludedBugs = new StringList();
    private Application app = null;
    private Set<Application> modules = null;
    private Set<AggregatedVuln> vulns = new TreeSet<AggregatedVuln>();
    private Set<AggregatedVuln> vulnsAboveThreshold = new TreeSet<AggregatedVuln>();
    private Set<AggregatedVuln> vulnsBelowThreshold = new TreeSet<AggregatedVuln>();
    private Set<String> historicalVulns = new HashSet<String>();
    private Set<String> relevantVulns = new HashSet<String>();
    final VelocityContext context = new VelocityContext();
    private GoalContext goalContext = null;

    public Report(GoalContext _ctx, Application _app, Set<Application> _modules) {
        this.goalContext = _ctx;
        this.app = _app;
        if (_modules == null) {
            this.modules = new HashSet<Application>();
            this.modules.add(this.app);
        } else {
            this.modules = _modules;
        }
        log.info((Object)("Report to be done for " + this.app + ", [" + this.modules.size() + "] modules in total: " + this.modules));
    }

    public String getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    public void setExceptionThreshold(String _threshold) {
        if (_threshold != null) {
            this.exceptionThreshold = _threshold;
        }
        log.info((Object)("Exception threshold: " + this.exceptionThreshold));
    }

    public void addExcludedBugs(String _items) {
        if (_items != null && !_items.equals("")) {
            this.excludedBugs.addAll(_items, ",", true);
            log.warn((Object)("Excluded bugs: " + this.excludedBugs));
        }
    }

    public void addExcludedBugs(String[] _items) {
        if (_items != null) {
            this.excludedBugs.addAll(_items, true);
            log.warn((Object)("Excluded bugs: " + this.excludedBugs));
        }
    }

    public void addExcludedScopes(String _items) {
        if (_items != null && !_items.equals("")) {
            this.excludedScopes.addAll(_items, ",", true);
            log.warn((Object)("Excluded scopes: " + this.excludedScopes));
        }
    }

    public void addExcludedScopes(String[] _items) {
        if (_items != null) {
            this.excludedScopes.addAll(_items, true);
            log.warn((Object)("Excluded scopes: " + this.excludedScopes));
        }
    }

    public void setIgnoreUnassessed(String _ignore) {
        if (_ignore != null) {
            if (_ignore.equalsIgnoreCase(IGN_UNASS_ALL)) {
                this.ignoreUnassessed = IGN_UNASS_ALL;
                log.warn((Object)"All unassessed vulnerabilities will be ignored");
            } else if (_ignore.equalsIgnoreCase(IGN_UNASS_OFF)) {
                this.ignoreUnassessed = IGN_UNASS_OFF;
            } else {
                this.ignoreUnassessed = IGN_UNASS_KNOWN;
                log.warn((Object)"All unassessed vulnerabilities in archives with known digests will be ignored");
            }
        }
    }

    private boolean ignoreUnassessed(VulnerableDependency _a) {
        if (this.ignoreUnassessed.equalsIgnoreCase(IGN_UNASS_OFF)) {
            return false;
        }
        if (this.ignoreUnassessed.equalsIgnoreCase(IGN_UNASS_ALL)) {
            return !_a.isAffectedVersionConfirmed();
        }
        return !_a.isAffectedVersionConfirmed() && _a.getDep().getLib().isWellknownDigest();
    }

    private boolean isAmongAggregatedModules(LibraryId _libid) {
        for (Application prj : this.modules) {
            if (!prj.getMvnGroup().equals(_libid.getMvnGroup()) || !prj.getArtifact().equals(_libid.getArtifact()) || !prj.getVersion().equals(_libid.getVersion())) continue;
            return true;
        }
        return false;
    }

    public void fetchAppVulnerabilities() throws IOException, BackendConnectionException {
        for (Application prj : this.modules) {
            try {
                Set<VulnerableDependency> historical_vuln_deps = BackendConnector.getInstance().getAppVulnDeps(this.goalContext, prj, true, false, true);
                for (VulnerableDependency v : historical_vuln_deps) {
                    this.historicalVulns.add(v.getBug().getBugId());
                }
                Set<VulnerableDependency> vuln_deps = BackendConnector.getInstance().getAppVulnDeps(this.goalContext, prj, false, true, true);
                for (VulnerableDependency v : vuln_deps) {
                    this.relevantVulns.add(v.getBug().getBugId());
                    v.setApp(prj);
                    AggregatedVuln new_av = new AggregatedVuln(v.getDep().getLib().getDigest(), v.getDep().getFilename(), v.getBug());
                    AggregatedVuln added_av = this.update(this.vulns, new_av);
                    if (v.getDep().getLib().getLibraryId() != null && this.isAmongAggregatedModules(v.getDep().getLib().getLibraryId())) {
                        log.warn((Object)("Skipping [" + v.getBug().getBugId() + "] for dependency of " + prj + " on " + v.getDep().getLib().getLibraryId() + ", the latter is one of the aggregated modules"));
                        continue;
                    }
                    added_av.addAnalysis(v);
                }
            }
            catch (BackendConnectionException e) {
                BackendConnectionException bce = new BackendConnectionException("Error fetching vulnerable dependencies for application (module) " + prj + ": " + e.getMessage(), e);
                log.error((Object)bce);
                throw bce;
            }
        }
    }

    private AggregatedVuln update(Set<AggregatedVuln> _set, AggregatedVuln _av) {
        for (AggregatedVuln av : _set) {
            if (!av.equals(_av)) continue;
            return av;
        }
        _set.add(_av);
        return _av;
    }

    public void processVulnerabilities() {
        TreeSet<AggregatedVuln> vulnsToReport = new TreeSet<AggregatedVuln>();
        long vulns_incl = 0L;
        long vulns_reach = 0L;
        long vulns_traced = 0L;
        long vulns_traced_not_reach = 0L;
        HashSet<String> obsolHistorical = new HashSet<String>();
        HashSet<String> obsolSignNotPresent = new HashSet<String>();
        for (String string : this.excludedBugs) {
            if (this.historicalVulns.contains(string) && !this.relevantVulns.contains(string)) {
                obsolHistorical.add(string);
                continue;
            }
            if (this.historicalVulns.contains(string) || this.relevantVulns.contains(string)) continue;
            obsolSignNotPresent.add(string);
        }
        if (!obsolHistorical.isEmpty()) {
            log.warn((Object)("Exemptions for the following vulnerabilities are obsolete, because they concern previous version(s) of the respective application dependency(ies) (historical vulnerability): [" + StringUtil.join(obsolHistorical, (String)", ") + "]"));
        }
        if (!obsolSignNotPresent.isEmpty()) {
            log.warn((Object)("Exemptions for the following vulnerabilities are obsolete, because none of the application dependencies contain potentially affected code signatures: [" + StringUtil.join(obsolSignNotPresent, (String)", ") + "]"));
        }
        for (AggregatedVuln aggregatedVuln : this.vulns) {
            for (VulnerableDependency analysis : aggregatedVuln.getAnalyses()) {
                analysis.setBlacklisted(this.isIgnoredForBuildException(analysis, aggregatedVuln.getBug().getBugId()));
                if (!analysis.isNoneAffectedVersion()) {
                    vulnsToReport.add(aggregatedVuln);
                    ++vulns_incl;
                }
                if (!(analysis.isNoneAffectedVersion() || !analysis.isReachable() && analysis.isReachableConfirmed())) {
                    ++vulns_reach;
                }
                if (!(analysis.isNoneAffectedVersion() || !analysis.isTraced() && analysis.isTracedConfirmed())) {
                    ++vulns_traced;
                }
                if (analysis.isTraced() && analysis.isReachable() && analysis.isReachableConfirmed()) {
                    ++vulns_traced_not_reach;
                }
                if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_DEP_ON) && (analysis.isAffectedVersion() || !analysis.isAffectedVersionConfirmed()) || this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_POT_EXE) && !analysis.isNoneAffectedVersion() && (analysis.isReachable() || !analysis.isReachableConfirmed()) || this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_ACT_EXE) && !analysis.isNoneAffectedVersion() && (analysis.isTraced() || !analysis.isTracedConfirmed())) {
                    analysis.setAboveThreshold(true);
                } else {
                    analysis.setAboveThreshold(false);
                }
                if (!analysis.isThrowsException().booleanValue()) continue;
                aggregatedVuln.aboveThreshold = true;
            }
        }
        for (AggregatedVuln aggregatedVuln : vulnsToReport) {
            if (aggregatedVuln.aboveThreshold) {
                this.vulnsAboveThreshold.add(aggregatedVuln);
                continue;
            }
            this.vulnsBelowThreshold.add(aggregatedVuln);
        }
        this.stats.put("report.vulnsIncluded", vulns_incl);
        this.stats.put("report.vulnsReachable", vulns_reach);
        this.stats.put("report.vulnsTraced", vulns_traced);
        this.stats.put("report.vulnsTracedNotReachable", vulns_traced_not_reach);
        this.stats.put("report.buildFailure", this.isThrowBuildException() ? 1L : 0L);
        this.stats.put("report.vulnsAboveThreshold", Long.valueOf(this.vulnsAboveThreshold.size()));
        this.stats.put("report.vulnsBelowThreshold", Long.valueOf(this.vulnsBelowThreshold.size()));
        this.stats.put("report.isAggregated", Long.valueOf(this.isAggregated() ? 1 : 0));
        this.stats.put("report.projectsReportedOn", Long.valueOf(this.modules.size()));
        this.context.put("vulnsToReport", vulnsToReport);
        this.context.put("vulnsAboveThreshold", this.vulnsAboveThreshold);
        this.context.put("vulnsBelowThreshold", this.vulnsBelowThreshold);
        this.context.put("obsoleteExemptionsHistorical", (Object)StringUtil.join(obsolHistorical, (String)", "));
        this.context.put("obsoleteExemptionsSignatureNotPresent", (Object)StringUtil.join(obsolSignNotPresent, (String)", "));
        this.context.put("vulas-backend-serviceUrl", (Object)this.goalContext.getVulasConfiguration().getServiceUrl(Service.BACKEND));
        this.context.put("app", (Object)this.app);
        this.context.put("space", (Object)this.goalContext.getSpace());
        this.context.put("projects", this.modules);
        this.context.put("generatedAt", (Object)this.dateFormat.format(new Date()));
        this.context.put("vulas-shared-homepage", (Object)this.goalContext.getVulasConfiguration().getConfiguration().getString("vulas.shared.homepage", "undefined"));
        this.context.put("exceptionThreshold", (Object)this.exceptionThreshold);
        this.context.put("exceptionScopeBlacklist", (Object)this.excludedScopes.toString(", "));
        this.context.put("exceptionExcludedBugs", (Object)this.excludedBugs.toString(", "));
        this.context.put("isAggregated", (Object)this.isAggregated());
        this.context.put("thresholdMet", (Object)this.vulnsAboveThreshold.isEmpty());
    }

    private boolean isAggregated() {
        return this.modules != null && this.modules.size() > 1;
    }

    public boolean isThrowBuildException() {
        return !this.exceptionThreshold.equalsIgnoreCase("none") && !this.vulnsAboveThreshold.isEmpty();
    }

    public Map<String, String> getConfiguration() {
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("report.exceptionThreshold", this.exceptionThreshold);
        cfg.put("report.exceptionScopeBlacklist", this.excludedScopes.toString(", "));
        cfg.put("report.exceptionExcludedBugs", this.excludedBugs.toString(", "));
        cfg.put("report.aggregated", Boolean.toString(this.isAggregated()));
        return cfg;
    }

    public Map<String, Long> getStats() {
        return this.stats;
    }

    public String getExceptionMessage() {
        StringBuilder builder = new StringBuilder();
        if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_DEP_ON)) {
            builder.append("Application depends on archives with vulnerable code");
        } else if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_POT_EXE)) {
            builder.append("Application potentially executes vulnerable code");
        } else if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_ACT_EXE)) {
            builder.append("Application actually executes vulnerable code");
        }
        return builder.toString();
    }

    public String getResultAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_DEP_ON)) {
            builder.append("The application depends on the following vulnerable archives: ");
        } else if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_POT_EXE)) {
            builder.append("The application potentially executes vulnerable code of the following vulnerable archives (or reachability was not checked): ");
        } else if (this.exceptionThreshold.equalsIgnoreCase(THRESHOLD_ACT_EXE)) {
            builder.append("The application actually executes vulnerable code of the following vulnerable archives (or no tests were run): ");
        }
        int i = 0;
        for (AggregatedVuln v : this.vulnsAboveThreshold) {
            for (VulnerableDependency analysis : v.getAnalyses()) {
                if (!analysis.isThrowsException().booleanValue()) continue;
                builder.append(System.getProperty("line.separator")).append("      ").append(++i).append(": ");
                builder.append("[filename=").append(v.filename);
                builder.append(", scope=").append(analysis.getDep().getScope());
                builder.append(", transitive=").append(analysis.getDep().getTransitive());
                builder.append(", wellknownSha1=").append(analysis.getDep().getLib().isWellknownDigest());
                builder.append(", isAffectedVersionConfirmed=").append(analysis.isAffectedVersionConfirmed());
                builder.append(", bug=").append(v.bug.getBugId()).append("]");
            }
        }
        return builder.toString();
    }

    public void writeResult(@NotNull Path _dir) {
        this.writeResultAsHtml(_dir);
        this.writeResultAsXml(_dir);
        this.writeResultAsJson(_dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path writeResult(@NotNull Path _dir, String _template, String _report) {
        Template template = null;
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        PrintWriter pw = null;
        File file = null;
        try {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(_template);
            if (input == null) {
                throw new IOException("Template file doesn't exist");
            }
            template = ve.getTemplate(_template);
            if (!FileUtil.isAccessibleDirectory((Path)_dir)) {
                Files.createDirectories(_dir, new FileAttribute[0]);
            }
            file = Paths.get(_dir.toString(), _report).toFile();
            pw = new PrintWriter(file, FileUtil.getCharsetName());
            template.merge((Context)this.context, (Writer)pw);
            log.info((Object)("Report with analysis results has been written to [" + file.toPath().toAbsolutePath().normalize() + "]"));
        }
        catch (Exception e) {
            log.error((Object)("Exception while creating report [" + file + "] with template [" + _template + "]: " + e.getMessage()));
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
        return file == null ? null : file.toPath().toAbsolutePath();
    }

    public Path writeResultAsHtml(@NotNull Path _dir) {
        return this.writeResult(_dir, TEMPLATE_FILE_HTML, REPORT_FILE_HTML);
    }

    public Path writeResultAsXml(@NotNull Path _dir) {
        return this.writeResult(_dir, TEMPLATE_FILE_XML, REPORT_FILE_XML);
    }

    public Path writeResultAsJson(@NotNull Path _dir) {
        return this.writeResult(_dir, TEMPLATE_FILE_JSON, REPORT_FILE_JSON);
    }

    private boolean isIgnoredForBuildException(VulnerableDependency _a, String _bugid) {
        return this.excludedScopes != null && _a.getDep().getScope() != null && this.excludedScopes.contains(_a.getDep().getScope().toString(), StringList.ComparisonMode.EQUALS, StringList.CaseSensitivity.CASE_INSENSITIVE) || this.excludedBugs != null && this.excludedBugs.contains(_bugid, StringList.ComparisonMode.EQUALS, StringList.CaseSensitivity.CASE_INSENSITIVE) || this.ignoreUnassessed(_a);
    }

    public static class AggregatedVuln
    implements Comparable {
        public String archiveid;
        public String filename;
        public Bug bug = null;
        public Set<VulnerableDependency> analyses = new HashSet<VulnerableDependency>();
        public boolean aboveThreshold = false;

        public String getArchiveid() {
            return this.archiveid;
        }

        public String getFilename() {
            return this.filename;
        }

        public Bug getBug() {
            return this.bug;
        }

        public void addAnalysis(VulnerableDependency _dep) {
            if (this.analyses.contains(_dep)) {
                return;
            }
            this.analyses.add(_dep);
        }

        public Set<VulnerableDependency> getAnalyses() {
            return this.analyses;
        }

        public AggregatedVuln(String _digest, String _filename, Bug _bug) {
            this.archiveid = _digest;
            this.filename = _filename;
            this.bug = _bug;
        }

        public boolean hasFindingsAboveThreshold() {
            return this.aboveThreshold;
        }

        public String toString() {
            return "[" + this.filename + ", " + this.bug.getBugId() + ", #analyses=" + this.analyses.size() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aboveThreshold ? 1231 : 1237);
            result = 31 * result + (this.archiveid == null ? 0 : this.archiveid.hashCode());
            result = 31 * result + (this.bug.getBugId() == null ? 0 : this.bug.getBugId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AggregatedVuln other = (AggregatedVuln)obj;
            if (this.archiveid == null ? other.archiveid != null : !this.archiveid.equals(other.archiveid)) {
                return false;
            }
            return !(this.bug == null ? other.bug != null : !this.bug.equals((Object)other.bug));
        }

        public int compareTo(Object _o) {
            AggregatedVuln other = null;
            if (!(_o instanceof AggregatedVuln)) {
                throw new IllegalArgumentException();
            }
            other = (AggregatedVuln)_o;
            int filename_comparison = this.filename == null || other.filename == null ? 0 : this.filename.compareTo(other.filename);
            int bugid_comparison = this.bug.compareTo((Object)other.getBug());
            if (filename_comparison != 0) {
                return filename_comparison;
            }
            return bugid_comparison;
        }
    }
}

