/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono;

import com.sap.scimono.api.Bulk;
import com.sap.scimono.api.Groups;
import com.sap.scimono.api.ResourceTypes;
import com.sap.scimono.api.Schemas;
import com.sap.scimono.api.ServiceProviderConfiguration;
import com.sap.scimono.api.ServletRequestProviderFilter;
import com.sap.scimono.api.Users;
import com.sap.scimono.api.helper.InternalExceptionMapper;
import com.sap.scimono.api.helper.JacksonResolver;
import com.sap.scimono.api.helper.JsonMappingExceptionMapper;
import com.sap.scimono.api.helper.JsonParseExceptionMapper;
import com.sap.scimono.api.helper.JsonProcessingExceptionMapper;
import com.sap.scimono.api.helper.ScimExceptionMapper;
import com.sap.scimono.api.helper.ValidationExceptionMapper;
import com.sap.scimono.callback.bulk.BulkRequestCallback;
import com.sap.scimono.callback.bulk.DefaultBulkRequestCallback;
import com.sap.scimono.callback.config.DefaultSCIMConfigurationCallback;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.groups.DefaultGroupsCallback;
import com.sap.scimono.callback.groups.GroupsCallback;
import com.sap.scimono.callback.resourcetype.DefaultResourceTypesCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.DefaultSchemasCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.callback.users.DefaultUsersCallback;
import com.sap.scimono.callback.users.UsersCallback;
import com.sap.scimono.entity.schema.validation.CustomInputValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCIMApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(SCIMApplication.class);
    private static final String SCIM_IMPLEMENTATION_INSTANCE = "SCIM_IMPLEMENTATION_INSTANCE";
    private Map<String, Object> props = new HashMap<String, Object>();

    public Map<String, Object> getProperties() {
        this.props.putAll(super.getProperties());
        this.props.put(SCIM_IMPLEMENTATION_INSTANCE, (Object)this);
        return this.props;
    }

    public Set<Class<?>> getClasses() {
        HashSet scimResources = new HashSet();
        scimResources.add(Users.class);
        scimResources.add(Groups.class);
        scimResources.add(Schemas.class);
        scimResources.add(ResourceTypes.class);
        scimResources.add(ServiceProviderConfiguration.class);
        scimResources.add(Bulk.class);
        scimResources.addAll(this.getAdditionalResourceProviders());
        scimResources.add(InternalExceptionMapper.class);
        scimResources.add(JacksonResolver.class);
        scimResources.add(JsonMappingExceptionMapper.class);
        scimResources.add(JsonParseExceptionMapper.class);
        scimResources.add(JsonProcessingExceptionMapper.class);
        scimResources.add(ScimExceptionMapper.class);
        scimResources.add(ServletRequestProviderFilter.class);
        logger.info("Initializing SCIM resource providers {}", scimResources);
        return scimResources;
    }

    public Set<Object> getSingletons() {
        return Collections.singleton(new ValidationExceptionMapper());
    }

    public static SCIMApplication from(Application app) {
        return (SCIMApplication)((Object)app.getProperties().get(SCIM_IMPLEMENTATION_INSTANCE));
    }

    public UsersCallback getUsersCallback() {
        return new DefaultUsersCallback();
    }

    public GroupsCallback getGroupsCallback() {
        return new DefaultGroupsCallback();
    }

    public SchemasCallback getSchemasCallback() {
        return new DefaultSchemasCallback();
    }

    public BulkRequestCallback getBulkRequestCallback() {
        return new DefaultBulkRequestCallback();
    }

    public ResourceTypesCallback getResourceTypesCallback() {
        return new DefaultResourceTypesCallback();
    }

    public SCIMConfigurationCallback getConfigurationCallback() {
        return new DefaultSCIMConfigurationCallback();
    }

    public Set<Class<?>> getAdditionalResourceProviders() {
        return Collections.emptySet();
    }

    public Map<CustomInputValidator.Type, CustomInputValidator> getCustomConstraintValidators() {
        return Collections.emptyMap();
    }
}

